import 'package:flutter/material.dart';

class NewNotificationManager with ChangeNotifier {
  bool _hasNewNotification = false;
  bool _hasJobseekerNewNotification = false;
  int _notificationCount = 0;
  int _jobseekerNotificationCount = 0;

  bool get hasNewNotification => _hasNewNotification;

  int get notificationCount => _notificationCount;

  bool get hasJobseekerNewNotification => _hasJobseekerNewNotification;

  int get jobseekerNotificationCount => _jobseekerNotificationCount;

  void updateNotificationCount(int count) {
    _notificationCount = count;
    _hasNewNotification = count > 0;
    notifyListeners();
  }

  void updateJobseekerNotificationCount(int count) {
    _jobseekerNotificationCount = count;
    _hasJobseekerNewNotification = count > 0;
    notifyListeners();
  }

  void dismiss() {
    _hasNewNotification = false;
    notifyListeners();
  }

  void jobseekerDismiss() {
    _hasJobseekerNewNotification = false;
    notifyListeners();
  }
}
