import 'package:job_portal_app/data/Common/identifier.dart';
import 'package:job_portal_app/data/Common/job.dart';
import 'package:job_portal_app/data/jobseeker/cv.dart';

import '../data/Common/interview.dart';
import '../data/Common/my_notification.dart';
import '../data/Common/person.dart';
import '../data/Common/skill.dart';
import '../data/Company/company.dart';

// ignore: camel_case_types
class fromJson {
  static CV toCv(Map<String, dynamic> json) {
    List<Skill> skillsList = [];
    for (var skill in json['skills']) {
      skillsList.add(Skill.fromJson(skill));
    }

    return CV(
      id: json['id'],
      stages: json['stages'],
      certificate: json['certificate'],
      previousWorks: json['previousWorks'],
      languages: json['languages'],
      specificationName: json['specificationName'],
      birthdate: DateTime.parse(json['birthdate']),
      gender: json['gender'],
      email: json['email'],
      address: json['address'],
      name: json['name'],
      phone: json['phone'],
      image: json['image'],
      skills: skillsList,
    );
  }

  static Company toCompany(Map<String, dynamic> json) {
    return Company(
      id: json['id'],
      description: json['description'],
      email: json['email'],
      address: json['address'],
      name: json['name'],
      phone: json['phone'],
      image: json['image'],
    );
  }

  static Job toJob(Map<String, dynamic> json) {
    List<Skill> skillsList = [];
    for (var skill in json['skills']) {
      skillsList.add(Skill.fromJson(skill));
    }

    return Job(
      id: json['id'],
      companyId: json['companyId'],
      companyName: json['companyName'],
      description: json['description'],
      name: json['name'],
      phone: json['phone'],
      email: json['email'],
      sallary: json['sallary'],
      specificationName: json['specificationName'],
      status: json['status'],
      timeType: json['timeType'],
      skills: skillsList,
      image: json['image'],
    );
  }

  static MyNotification toMyNotification(Map<String, dynamic> json) {
    return MyNotification(
        id: json['id'],
        companyId: json['companyId'],
        jobSeekerId: json['jobSeekerId'],
        details: json['details'],
        date: json['date'],
        image: json['image'],
        toCompany: json['toCompany'],
        name: json['name']);
  }

  static Interview toInterview(Map<String, dynamic> json) {
    return Interview(
        id: json['id'],
        companyId: json['companyId'],
        jobSeekerId: json['jobSeekerId'],
        address: json['address'],
        date: json['date'],
        image: json['image'],
        jobId: json['jobId'],
        jobName: json['jobName'],
        name: json['name']);
  }

  static Identifier toIdentifier(Map<String, dynamic> json) {
    int id;
    String token;
    bool isCompany;
    id = json['id'];
    token = json['token'];
    isCompany = json['isCompany'];
    return Identifier(id, token, isCompany);
  }

  static Person toPerson(Map<String, dynamic> json) {
    String name = json['name'];
    String email = json['email'];
    String image = "/Images/${json['image']}";
    return Person(image, name, email);
  }

  static String toErrors(Map<String, dynamic> json) {
    List<String> errors = [];
    for (var error in json['errors']) {
      errors.add(error.toString());
    }
    return errors[0];
  }
}
