import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/Common/my_notification.dart';

import '../UI/Notification/jobseeker_notification_details_screen.dart';

class MyJobseekerNotificationWidget extends StatefulWidget {
  final MyNotification notification;

  const MyJobseekerNotificationWidget({super.key, required this.notification});

  @override
  State<MyJobseekerNotificationWidget> createState() =>
      _MyJobseekerNotificationWidgetState();
}

class _MyJobseekerNotificationWidgetState
    extends State<MyJobseekerNotificationWidget> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.white24,
        child: ListTile(
          onLongPress: () {},
          onTap: () {
            Navigator.pushReplacement(
                context,
                MaterialPageRoute(
                    builder: (context) => JobseekerNotificationDetailsScreen(
                        notification: widget.notification)));
          },
          leading: Container(
              width: 100,
              height: 150,
              padding: const EdgeInsets.only(right: 8.0),
              decoration: const BoxDecoration(
                border: Border(right: BorderSide(width: 1)),
              ),
              child: Expanded(
                child: Image.network(
                  '$myUrl/${widget.notification.image}',
                  fit: BoxFit.cover,
                ),
              )),
          title: Text(widget.notification.name,
              style: const TextStyle(
                  color: Colors.amber,
                  fontSize: 18,
                  fontWeight: FontWeight.bold),
              maxLines: 2,
              overflow: TextOverflow.ellipsis),
          subtitle: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              const SizedBox(
                height: 5,
              ),
              Text(widget.notification.details,
                  style: const TextStyle(
                    color: Colors.black,
                    fontSize: 13,
                  ),
                  maxLines: 3,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
            ],
          ),
          trailing: const Icon(
            Icons.keyboard_arrow_right,
            color: Colors.black,
            size: 30,
          ),
        ),
      ),
    );
  }
}
