import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';

import '../UI/Company/jobseeker_profile_screen.dart';
import '../data/jobseeker/cv.dart';

// ignore: must_be_immutable
class JobseekerWidget extends StatefulWidget {
  final CV cv;

  const JobseekerWidget({
    super.key,
    required this.cv,
  });

  @override
  State<JobseekerWidget> createState() => _JobseekerWidgetState();
}

class _JobseekerWidgetState extends State<JobseekerWidget> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.white24,
        child: ListTile(
          onLongPress: () {},
          onTap: () {
            Navigator.push(
                context,
                MaterialPageRoute(
                    builder: (context) =>
                        JobseekerProfileScreen(id: widget.cv.id)));
          },
          leading: Container(
              width: 100,
              height: 150,
              padding: const EdgeInsets.only(right: 8.0),
              decoration: const BoxDecoration(
                border: Border(right: BorderSide(width: 1)),
              ),
              child: Expanded(
                child: Image.network(
                  '$myUrl/${widget.cv.image}',
                  fit: BoxFit.fill,
                ),
              )),
          title: Text(widget.cv.name,
              style: const TextStyle(
                  color: Colors.amber,
                  fontSize: 18,
                  fontWeight: FontWeight.bold),
              maxLines: 2,
              overflow: TextOverflow.ellipsis),
          subtitle: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(widget.cv.specificationName,
                  style: const TextStyle(
                      color: Colors.black,
                      fontSize: 15,
                      fontWeight: FontWeight.bold),
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
              Text(widget.cv.gender,
                  style: const TextStyle(
                    color: Colors.black,
                    fontSize: 13,
                  ),
                  maxLines: 3,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
            ],
          ),
          trailing: const Icon(
            Icons.keyboard_arrow_right,
            color: Colors.black,
            size: 30,
          ),
        ),
      ),
    );
  }
}
