import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:image_picker/image_picker.dart';

import '../Services/global_methods.dart';

// ignore: must_be_immutable
class ImageProfileWidget extends StatefulWidget {
  File? image;

  final void Function(File pickedImage)? onImagePicked;

  ImageProfileWidget({Key? key, this.onImagePicked, this.image})
      : super(key: key);

  @override
  State<ImageProfileWidget> createState() => _ImageProfileWidgetState();
}

class _ImageProfileWidgetState extends State<ImageProfileWidget> {
  final ImagePicker _picker = ImagePicker();

  void takePhoto(ImageSource source) async {
    try {
      final pickedFile = await _picker.pickImage(source: source);
      if (pickedFile == null) return;
      final imageTemporery = File(pickedFile.path);
      setState(() {
        widget.image = imageTemporery;
      });
      if (widget.onImagePicked != null) {
        widget.onImagePicked!(imageTemporery);
      }
    } on PlatformException catch (e) {
      GlobalMethods.showErrorDialog(ctx: context, error: e.toString());
    }
  }

  Widget bottomSheet() {
    return Container(
        height: 100.0,
        width: MediaQuery.of(context).size.width,
        margin: const EdgeInsets.symmetric(horizontal: 20.0, vertical: 20.0),
        child: Column(
          children: [
            const Text(
              "Choose your profile image",
              style: TextStyle(fontSize: 20.0),
            ),
            const SizedBox(height: 20.0),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceAround,
              children: <Widget>[
                TextButton(
                  child: const Row(
                    children: [Icon(Icons.camera_alt), Text(" camera")],
                  ),
                  onPressed: () {
                    takePhoto(ImageSource.camera);
                  },
                ),
                TextButton(
                  child: const Row(
                    children: [Icon(Icons.image), Text(" gallery")],
                  ),
                  onPressed: () {
                    takePhoto(ImageSource.gallery);
                  },
                ),
              ],
            )
          ],
        ));
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Stack(
        children: [
          Padding(
            padding: const EdgeInsets.all(14.0),
            child: widget.image != null
                ? CircleAvatar(
                    radius: 80.0,
                    child: ClipOval(
                      child: Image.file(widget.image!,
                          width: 160, height: 160, fit: BoxFit.cover),
                    ),
                  )
                : CircleAvatar(
                    radius: 80.0,
                    child: ClipOval(
                      child: Image.asset(
                        "Images/profile.png",
                        fit: BoxFit.cover,
                      ),
                    ),
                  ),
          ),
          Positioned(
              bottom: 20.0,
              right: 20.0,
              child: InkWell(
                onTap: () {
                  showModalBottomSheet(
                    context: context,
                    builder: (builder) => bottomSheet(),
                  );
                },
                child: const Icon(
                  Icons.camera_alt,
                  color: Colors.teal,
                  size: 20.0,
                ),
              )),
        ],
      ),
    );
  }
}
