import 'package:flutter/material.dart';
import 'package:job_portal_app/UI/jobseeker/edit_my_skills_screen.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Services/global_methods.dart';
import '../../UI/Common/change_your_password.dart';
import '../../data/jobseeker/cv.dart';
import '../Bottom_Navigation_Bar/bottom_navigation_bar.dart';
import 'edit_personal_information_screen.dart';

class ManageAccountScreen extends StatefulWidget {
  const ManageAccountScreen({super.key});

  @override
  State<ManageAccountScreen> createState() => _ManageAccountScreenState();
}

class _ManageAccountScreenState extends State<ManageAccountScreen> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        bottomNavigationBar: MyBottomNavigationBar(
          indexNum: 3,
        ),
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          flexibleSpace: Container(
            decoration: const BoxDecoration(
                gradient: LinearGradient(
                    colors: [Colors.cyan, Colors.greenAccent],
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [0.2, 0.9])),
          ),
          title: const Text("Setting"),
          centerTitle: true,
        ),
        body: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.2, 0.9])),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              GestureDetector(
                  onTap: () {
                    Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => const EditMySkillsScreen()));
                  },
                  child: GlobalMethods.userInfo(
                      myIcon: Icons.settings, content: "Skills Setting")),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => FutureBuilder<CV>(
                        future: fetch.fetchCV(),
                        builder: (context, snapshot) {
                          if (snapshot.connectionState ==
                              ConnectionState.waiting) {
                            return SafeArea(
                              child: Container(
                                  decoration: const BoxDecoration(
                                      gradient: LinearGradient(
                                          colors: [
                                            Colors.cyan,
                                            Colors.greenAccent
                                          ],
                                          begin: Alignment.centerLeft,
                                          end: Alignment.centerRight,
                                          stops: [0.2, 0.9])),
                                  child: const Center(
                                      child: CircularProgressIndicator())),
                            );
                          } else if (snapshot.hasError) {
                            return Text("Error: ${snapshot.error}");
                          } else {
                            return EditPersonalInformationScreen(
                                cv: snapshot.data);
                          }
                        },
                      ),
                    ),
                  );
                },
                child: GlobalMethods.userInfo(
                    myIcon: Icons.settings,
                    content: "Personal Infomation Setting"),
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => FutureBuilder<CV>(
                        future: fetch.fetchCV(),
                        builder: (context, snapshot) {
                          if (snapshot.connectionState ==
                              ConnectionState.waiting) {
                            return SafeArea(
                              child: Container(
                                  decoration: const BoxDecoration(
                                      gradient: LinearGradient(
                                          colors: [
                                            Colors.cyan,
                                            Colors.greenAccent
                                          ],
                                          begin: Alignment.centerLeft,
                                          end: Alignment.centerRight,
                                          stops: [0.2, 0.9])),
                                  child: const Center(
                                      child: CircularProgressIndicator())),
                            );
                          } else if (snapshot.hasError) {
                            return Text("Error: ${snapshot.error}");
                          } else {
                            return const ChangeYourPassword();
                          }
                        },
                      ),
                    ),
                  );
                },
                child: GlobalMethods.userInfo(
                    myIcon: Icons.settings, content: "Change Your Password"),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
