import 'package:curved_navigation_bar/curved_navigation_bar.dart';
import 'package:flutter/material.dart';
import 'package:job_portal_app/UI/jobseeker/manage_account_screen.dart';

import '../../Services/global_methods.dart';
import '../jobseeker/favorites_screen.dart';
import '../jobseeker/jobseeker_home_screen.dart';
import '../jobseeker/profile_screen.dart';
import '../jobseeker/search_jobs_screen.dart';

// ignore: must_be_immutable
class MyBottomNavigationBar extends StatelessWidget {
  int indexNum = 0;

  MyBottomNavigationBar({super.key, required this.indexNum});

  @override
  Widget build(BuildContext context) {
    return CurvedNavigationBar(
      index: indexNum,
      height: 50,
      animationDuration: const Duration(milliseconds: 300),
      animationCurve: Curves.bounceInOut,
      onTap: (index) {
        if (index == 0) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const JobSeekerHomeScreen()));
        } else if (index == 1) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const SearchJobsScreen()));
        } else if (index == 2) {
          Navigator.pushReplacement(context,
              MaterialPageRoute(builder: (context) => const ProfileScreen()));
        } else if (index == 3) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const ManageAccountScreen()));
        } else if (index == 4) {
          Navigator.pushReplacement(context,
              MaterialPageRoute(builder: (context) => const FavoritesScreen()));
        } else if (index == 5) {
          GlobalMethods.logout(context);
        }
      },
      items: const [
        Icon(
          Icons.home,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.search,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.person_pin,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.settings,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.star,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.logout,
          size: 19,
          color: Colors.black87,
        ),
      ],
      backgroundColor: Colors.green,
      buttonBackgroundColor: Colors.cyan.shade100,
      color: Colors.cyan.shade200,
    );
  }
}
