import 'package:flutter/material.dart';
import 'package:job_portal_app/Logic/fetch.dart';
import 'package:job_portal_app/Services/global_methods.dart';
import 'package:job_portal_app/Widgets/interview_widget.dart';

import '../../data/Common/interview.dart';

// ignore: must_be_immutable
class SearchInMyInterviewsScreen extends StatefulWidget {
  int id;

  SearchInMyInterviewsScreen({super.key, required this.id});

  @override
  State<SearchInMyInterviewsScreen> createState() =>
      _SearchInMyInterviewsScreenState();
}

class _SearchInMyInterviewsScreenState
    extends State<SearchInMyInterviewsScreen> {
  List<Interview> interviewsList = [];
  List<Interview> filteredInterviews = [];
  final TextEditingController _search = TextEditingController();
  String searchQuery = "Search query";

  @override
  void initState() {
    super.initState();
    _loadInterviews();
  }

  void _loadInterviews() async {
    try {
      List<Interview> fetchedInterviews =
          await fetch.getAllInterviewsByJobId(widget.id);
      setState(() {
        interviewsList = fetchedInterviews;
      });
    } catch (error) {
      GlobalMethods.showErrorDialog(ctx: context, error: error.toString());
    }
  }

  Widget _searchField() {
    return TextField(
      controller: _search,
      autocorrect: true,
      decoration: const InputDecoration(
          border: InputBorder.none,
          hintText: "Search for interviews....",
          hintStyle: TextStyle(color: Colors.white)),
      style: const TextStyle(color: Colors.white, fontSize: 16.0),
      onChanged: (query) => _updateSearch(query),
    );
  }

  List<Widget> _buildActions() {
    return <Widget>[
      IconButton(
          onPressed: () {
            _clearSearch();
          },
          icon: const Icon(Icons.clear))
    ];
  }

  void _clearSearch() {
    setState(() {
      _search.clear();
      _updateSearch("");
    });
  }

  void _updateSearch(String newQuery) {
    setState(() {
      searchQuery = newQuery;
      filteredInterviews = interviewsList
          .where((interview) =>
              interview.name.toLowerCase().contains(searchQuery.toLowerCase()))
          .toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.1, 1])),
          child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              title: _searchField(),
              actions: _buildActions(),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
            ),
            body: ListView.builder(
              itemCount: filteredInterviews.length,
              itemBuilder: (context, index) {
                return InterviewWidget(interview: filteredInterviews[index]);
              },
            ),
          )),
    );
  }
}
