﻿using AutoMapper;
using JobPortalAPI.DTOs;
using JobPortalAPI.Models;
using JobPortalAPI.UnitOfWork;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace JobPortalAPI.Controllers
{
    [Authorize(AuthenticationSchemes = JwtBearerDefaults.AuthenticationScheme)]

    [Route("api/[controller]")]
    [ApiController]
    public class SkillsController : BaseController
    {
        private readonly IMapper _mapper;
        public SkillsController(IUnitOfWork unitOfWork, IMapper mapper)
            : base(unitOfWork)
        {
            _mapper = mapper;

        }
        [HttpGet]
        public IActionResult GetAll()
        {
            var skills = _unitOfWork.SkillRepo.GetAll().ToList();
            return Ok(skills);
        }

        [HttpGet("{id}")]
        public IActionResult Get(int id)
        {
            var skill = _unitOfWork.SkillRepo.Get(id);
            if (skill == null)
            {
                return NotFound();
            }
            return Ok(skill);
        }

        [HttpPost]
        public IActionResult Create(String skillname)
        {
            if (ModelState.IsValid)
            {
                Skill skill = new Skill();
                skill.Name = skillname.ToUpper();
                _unitOfWork.SkillRepo.Add(skill);
                _unitOfWork.SaveChanges();
                return Ok(skill);
            }
            else
            {
                return BadRequest("Invalid Request");
            }
        }

        [HttpPut("{id}")]
        public IActionResult Update(int id, String skillname)
        {
            var skill = _unitOfWork.SkillRepo.Get(id);
            if (skill == null)
            {
                return NotFound();
            }
            else
            {
                skill.Name = skillname.ToUpper();
                _unitOfWork.SkillRepo.Update(skill);
                _unitOfWork.SaveChanges();
                return Ok(skill);
            }

        }

        [HttpDelete("{id}")]
        public IActionResult Delete(int id)
        {
            var skill = _unitOfWork.SkillRepo.Get(id);
            if (skill == null)
            {
                return NotFound();
            }
            _unitOfWork.SkillRepo.Remove(skill);
            _unitOfWork.SaveChanges();
            return Ok();
        }
        //[HttpGet("test")]
        //public IActionResult test()
        //{
           
        //    return Ok("success");
        //}
    }
}
