﻿using AutoMapper;
using JobPortalAPI.DTOs;
using JobPortalAPI.Models;
using JobPortalAPI.UnitOfWork;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Build.Tasks.Deployment.Bootstrapper;
using Microsoft.EntityFrameworkCore;
using System.Xml;
using static System.Net.Mime.MediaTypeNames;


namespace JobPortalAPI.Controllers
{
    [Authorize(AuthenticationSchemes = JwtBearerDefaults.AuthenticationScheme)]

    [Route("api/[controller]")]
    [ApiController]
    public class PersonsController : BaseController
    {
        private readonly IMapper _mapper;
        public PersonsController(IUnitOfWork unitOfWork, IMapper mapper)
            : base(unitOfWork)
        {
            _mapper = mapper;

        }
        [HttpGet]
        public IActionResult GetAll()
        {
            var persons = _unitOfWork.PersonRepo.GetAll().ToList();
            //var persons = _unitOfWork.PersonRepo.GetAllWithJobSeekers().ToList();

            return Ok(persons);
        }

        [HttpGet("{id}")]
        public IActionResult Get(int id)
        {
            var person = _unitOfWork.PersonRepo.Get(id);
            if (person == null)
            {
                return NotFound();
            }
            return Ok(person);
        }

        [HttpPost]
        public IActionResult Create([FromForm] PersonDto dto)
        {
            if (ModelState.IsValid)
            {


                var person = _mapper.Map<Person>(dto);

                if (dto.Image != null && dto.Image.Length > 0)
                {
                    var fileName = Guid.NewGuid().ToString() + Path.GetExtension(dto.Image.FileName);
                    var filePath = fileName;
                    var fullPath = Path.Combine(@"A:\\Mobile_Application\\JobPortalAPI\\JobPortalAPI\\Images", filePath);
                    using (var stream = new FileStream(fullPath, FileMode.Create))
                    {
                        dto.Image.CopyTo(stream);
                    }
                    person.Image = filePath;

                }

                else
                {
                    return BadRequest("Image is required");

                }
             
                _unitOfWork.PersonRepo.Add(person);
                _unitOfWork.SaveChanges();
                return Ok(person);

            }
            else
            {
                return BadRequest("Invalid Request");
            }

        }

        [HttpPut("{id}")]
        public IActionResult Update(int id, [FromForm] PersonDto dto)
        {
            var person = _unitOfWork.PersonRepo.Get(id);
            if (person == null)
            {
                return NotFound();
            }
            else
            {
                var currentImage = Path.Combine(@"A:\\Mobile_Application\\JobPortalAPI\\JobPortalAPI\\Images", person.Image); 

                _mapper.Map<PersonDto, Person>(dto, person);

                if (dto.Image != null && dto.Image.Length > 0)
                {
                    var fileName = Guid.NewGuid().ToString() + Path.GetExtension(dto.Image.FileName);
                    var filePath = fileName;
                    var fullPath = Path.Combine(@"A:\\Mobile_Application\\JobPortalAPI\\JobPortalAPI\\Images", filePath);
                    using (var stream = new FileStream(fullPath, FileMode.Create))
                    {
                        dto.Image.CopyTo(stream);
                    }
                    if (!string.IsNullOrEmpty(currentImage) && System.IO.File.Exists(currentImage))
                    {
                        System.IO.File.Delete(currentImage);
                    }
                    person.Image = filePath;


                }
                else if (!string.IsNullOrEmpty(currentImage))
                {
                    person.Image = currentImage;
                }

                else
                {
                    return BadRequest("Image is required");

                }

                _unitOfWork.PersonRepo.Update(person);
                _unitOfWork.SaveChanges();
                return Ok(person);
            }

        }

        [HttpDelete("{id}")]
        public IActionResult Delete(int id)
        {
            var person = _unitOfWork.PersonRepo.Get(id);
            if (person == null)
            {
                return NotFound();
            }
            _unitOfWork.PersonRepo.Remove(person);
            _unitOfWork.SaveChanges();
            return Ok();
        }
    }
}
