import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/Common/my_notification.dart';

import '../jobseeker/show_company_profile_screen.dart';
import 'show_jobseekers_notification_screen.dart';

class JobseekerNotificationDetailsScreen extends StatefulWidget {
  final MyNotification notification;

  const JobseekerNotificationDetailsScreen(
      {super.key, required this.notification});

  @override
  State<JobseekerNotificationDetailsScreen> createState() =>
      _JobseekerNotificationDetailsScreenState();
}

class _JobseekerNotificationDetailsScreenState
    extends State<JobseekerNotificationDetailsScreen> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
        decoration: const BoxDecoration(
            gradient: LinearGradient(
                colors: [Colors.cyan, Colors.greenAccent],
                begin: Alignment.centerLeft,
                end: Alignment.centerRight,
                stops: [0.1, 1])),
        child: SafeArea(
            child: Scaffold(
                backgroundColor: Colors.transparent,
                appBar: AppBar(
                  flexibleSpace: Container(
                    decoration: const BoxDecoration(
                        gradient: LinearGradient(
                            colors: [Colors.cyan, Colors.greenAccent],
                            begin: Alignment.centerLeft,
                            end: Alignment.centerRight,
                            stops: [0.2, 0.9])),
                  ),
                  leading: IconButton(
                    icon: const Icon(
                      Icons.close,
                      size: 20,
                      color: Colors.black,
                    ),
                    onPressed: () {
                      Navigator.pushReplacement(
                          context,
                          MaterialPageRoute(
                              builder: (context) =>
                                  const ShowJobseekersNotificationScreen()));
                    },
                  ),
                ),
                body: SingleChildScrollView(
                  child: Padding(
                    padding: const EdgeInsets.all(0),
                    child: Column(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: Card(
                              color: Colors.black54,
                              child: Column(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  const Padding(
                                    padding: EdgeInsets.all(8.0),
                                    child: Center(
                                        child: Text(
                                      "Notification",
                                      style: TextStyle(
                                          color: Colors.amber,
                                          fontSize: 30,
                                          fontWeight: FontWeight.bold),
                                    )),
                                  ),
                                  const SizedBox(
                                    height: 8,
                                  ),
                                  SizedBox(
                                    width: MediaQuery.of(context).size.width,
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      children: [
                                        GestureDetector(
                                          onTap: () {
                                            _goToProfile(context);
                                          },
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                            children: [
                                              Padding(
                                                padding:
                                                    const EdgeInsets.all(8.0),
                                                child: Container(
                                                  decoration: BoxDecoration(
                                                    border: Border.all(
                                                        width: 3,
                                                        color: Colors.grey),
                                                    image: DecorationImage(
                                                      image: NetworkImage(
                                                          '$myUrl/${widget.notification.image}'),
                                                      fit: BoxFit.fill,
                                                    ),
                                                  ),
                                                  width: 100,
                                                  height: 100,
                                                ),
                                              ),
                                              const SizedBox(
                                                width: 40,
                                              ),
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    top: 8.0),
                                                child: Column(
                                                  mainAxisAlignment:
                                                      MainAxisAlignment.center,
                                                  crossAxisAlignment:
                                                      CrossAxisAlignment.center,
                                                  children: [
                                                    Text(
                                                      widget.notification.name,
                                                      style: const TextStyle(
                                                          color: Colors.white,
                                                          fontSize: 20,
                                                          fontWeight:
                                                              FontWeight.bold),
                                                    ),
                                                    const SizedBox(
                                                      height: 5,
                                                    ),
                                                    MaterialButton(
                                                      onPressed: () {
                                                        _goToProfile(context);
                                                      },
                                                      color: Colors.blueAccent,
                                                      shape:
                                                          const RoundedRectangleBorder(),
                                                      child: const Text(
                                                        "Show Profile",
                                                        style: TextStyle(
                                                          color: Colors.white,
                                                          fontWeight:
                                                              FontWeight.bold,
                                                        ),
                                                      ),
                                                    )
                                                  ],
                                                ),
                                              )
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  const SizedBox(
                                    height: 8,
                                    child: Divider(
                                      color: Colors.grey,
                                    ),
                                  ),
                                  Padding(
                                    padding: const EdgeInsets.all(8.0),
                                    child: Text(
                                      widget.notification.details,
                                      textAlign: TextAlign.justify,
                                      style: const TextStyle(
                                        color: Colors.grey,
                                        fontSize: 14,
                                      ),
                                    ),
                                  ),
                                  Row(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    children: [
                                      const Padding(
                                        padding: EdgeInsets.all(8.0),
                                        child: Text(
                                          "Received at:",
                                          style: TextStyle(
                                              color: Colors.grey,
                                              fontSize: 18,
                                              fontWeight: FontWeight.bold),
                                        ),
                                      ),
                                      Padding(
                                        padding: const EdgeInsets.all(8.0),
                                        child: Text(
                                          "${DateFormat.yMd().format(DateTime.parse(widget.notification.date))}   ${DateFormat.Hm().format(DateTime.parse(widget.notification.date))}",
                                          textAlign: TextAlign.justify,
                                          style: const TextStyle(
                                            color: Colors.grey,
                                            fontSize: 14,
                                          ),
                                        ),
                                      ),
                                    ],
                                  )
                                ],
                              ),
                            ),
                          ),
                        ]),
                  ),
                ))));
  }

  void _goToProfile(context) {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black87,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Move",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: Text(
          "show ${widget.notification.name} profile?",
          style: const TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
                Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) => ShowCompanyProfileScreen(
                              id: widget.notification.companyId,
                            )));
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }
}
