import 'package:flutter/material.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Widgets/job_seeker_widget.dart';
import '../../data/jobseeker/cv.dart';

// ignore: must_be_immutable
class ShowAllJobseekersScreen extends StatefulWidget {
  const ShowAllJobseekersScreen({
    super.key,
  });

  @override
  State<ShowAllJobseekersScreen> createState() =>
      _ShowAllJobseekersScreenState();
}

class _ShowAllJobseekersScreenState extends State<ShowAllJobseekersScreen> {
  int x = 0;
  Future<List<CV>>? _futureCVs;

  @override
  void initState() {
    _futureCVs = fetch.getAllJobseekers();
    getCvCount();
    super.initState();
  }

  void getCvCount() {
    _futureCVs?.then((List<CV>? cvList) {
      if (cvList != null) {
        setState(() {
          x = cvList.length;
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 25,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              title: Text("$x jobseeker"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder(
                future: _futureCVs,
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<CV>? cvs = snapshot.data;
                    return ListView.builder(
                      itemCount: cvs!.length,
                      itemBuilder: (context, index) {
                        CV cv = cvs[index];
                        return JobseekerWidget(
                          cv: cv,
                        );
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
