﻿using JobPortalAPI.IRepository;
using JobPortalAPI.Models;
using Microsoft.EntityFrameworkCore;

namespace JobPortalAPI.Repository
{
    public class JobRepository : Repository<Job>, IJobRepository
    {
        public JobRepository(JobPortalDBContext context) : base(context)
        {
        }
        public JobPortalDBContext CurrDbContext
        {
            get { return Context as JobPortalDBContext; }     
        }
        public Job GetAllJobDetails(int id)
        {
            var x = Context.Jobs.Include(j => j.Company).Include(j => j.JobSkills).FirstOrDefault(j => j.Id == id);
            return x;
        }
        public List<Job> GetAllJobsDetails()
        {
            var x = Context.Jobs.Include(j => j.Company).Include(j => j.JobSkills).ToList();
            return x;
        }

        public List<Job> GetAllJobsDetailsByCompanyId(int id)
        {
            var x = Context.Jobs.Include(j => j.Company).Include(j => j.JobSkills).Where(j => j.CompanyId == id).ToList();
            return x;
        }
    }
}
    

