﻿using AutoMapper;
using JobPortalAPI.DTOs;
using JobPortalAPI.Models;
using JobPortalAPI.UnitOfWork;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace JobPortalAPI.Controllers
{
    [Authorize(AuthenticationSchemes = JwtBearerDefaults.AuthenticationScheme)]

    [Route("api/[controller]")]
    [ApiController]
    public class SpecificationsController : BaseController
    {
        private readonly IMapper _mapper;
        public SpecificationsController(IUnitOfWork unitOfWork, IMapper mapper)
            : base(unitOfWork)
        {
            _mapper = mapper;

        }
        [AllowAnonymous]

        [HttpGet]
        public IActionResult GetAll()
        {
            var specifications = _unitOfWork.SpecificationRepo.GetAll().ToList();
            return Ok(specifications);
        }

        [HttpGet("{id}")]
        public IActionResult Get(int id)
        {
            var specification = _unitOfWork.SpecificationRepo.Get(id);
            if (specification == null)
            {
                return NotFound();
            }
            return Ok(specification);
        }

        [AllowAnonymous]
        [HttpPost]
        public IActionResult Create(String specificationName)
        {
            if (ModelState.IsValid)
            { 
                
                var x = _unitOfWork.SpecificationRepo.GetAll().FirstOrDefault(s => s.Name.ToUpper().Contains(specificationName.ToUpper()));
                if(x == null)
                {
                    Specification specification = new Specification();
                    specification.Name = specificationName.ToUpper();
                    _unitOfWork.SpecificationRepo.Add(specification);
                    _unitOfWork.SaveChanges();
                    return Ok(specification);
                }
                return BadRequest("this specification is already exist");
            }
            else
            {
                return BadRequest(new AuthResult() { Errors = new List<string>() { "Enter valid values" } });
            }
        }

        [HttpPut("{id}")]
        public IActionResult Update(int id, String specificationName)
        {
            var specification = _unitOfWork.SpecificationRepo.Get(id);
            if (specification == null)
            {
                return NotFound();
            }
            else
            {
                specification.Name = specificationName.ToUpper();
                _unitOfWork.SpecificationRepo.Update(specification);
                _unitOfWork.SaveChanges();
                return Ok(specification);
            }

        }

        [HttpDelete("{id}")]
        public IActionResult Delete(int id)
        {
            var specification = _unitOfWork.SpecificationRepo.Get(id);
            if (specification == null)
            {
                return NotFound();
            }
            _unitOfWork.SpecificationRepo.Remove(specification);
            _unitOfWork.SaveChanges();
            return Ok();
        }
    }
}
