import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/Common/job.dart';

import '../UI/Company/job_details_for_company_screen.dart';

class ShowJobWidget extends StatefulWidget {
  final Job job;

  const ShowJobWidget({super.key, required this.job});

  @override
  State<ShowJobWidget> createState() => _ShowJobWidgetState();
}

class _ShowJobWidgetState extends State<ShowJobWidget> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.white24,
        child: ListTile(
          onLongPress: () {},
          onTap: () {
            Navigator.pushReplacement(
                context,
                MaterialPageRoute(
                    builder: (context) =>
                        JobDetailsForCompanyScreen(job: widget.job)));
          },
          leading: Container(
              width: 100,
              height: 300,
              padding: const EdgeInsets.only(right: 8.0),
              decoration: const BoxDecoration(
                border: Border(right: BorderSide(width: 1)),
              ),
              child: SizedBox(
                width: 100,
                height: 300,
                child: ClipRRect(
                  borderRadius: BorderRadius.circular(4.0),
                  child: Image.network(
                    '$myUrl/${widget.job.image}',
                    fit: BoxFit.cover,
                  ),
                ),
              )),
          title: Text(widget.job.companyName,
              style: const TextStyle(
                  color: Colors.amber,
                  fontSize: 18,
                  fontWeight: FontWeight.bold),
              maxLines: 2,
              overflow: TextOverflow.ellipsis),
          subtitle: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(widget.job.name,
                  style: const TextStyle(
                      color: Colors.black,
                      fontSize: 15,
                      fontWeight: FontWeight.bold),
                  maxLines: 2,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
              Text(widget.job.description,
                  // textAlign: TextAlign.justify,
                  style: const TextStyle(
                    color: Colors.black,
                    fontSize: 13,
                  ),
                  maxLines: 3,
                  overflow: TextOverflow.ellipsis),
              const SizedBox(
                height: 8,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  Text(
                    widget.job.sallary.toString(),
                    style: const TextStyle(
                      color: Colors.black,
                      fontSize: 13,
                    ),
                  ),
                  const Icon(
                    Icons.attach_money,
                    size: 13,
                    color: Colors.black,
                  )
                ],
              )
            ],
          ),
          trailing: const Icon(
            Icons.keyboard_arrow_right,
            color: Colors.black,
            size: 30,
          ),
        ),
      ),
    );
  }
}
