import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/jobseeker/cv.dart';
import 'package:job_portal_app/logic/fetch.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../Services/global_methods.dart';

// ignore: must_be_immutable
class JobseekerProfileScreen extends StatefulWidget {
  int id;

  JobseekerProfileScreen({super.key, required this.id});

  @override
  State<JobseekerProfileScreen> createState() => _JobseekerProfileScreenState();
}

class _JobseekerProfileScreenState extends State<JobseekerProfileScreen> {
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          flexibleSpace: Container(
            decoration: const BoxDecoration(
                gradient: LinearGradient(
                    colors: [Colors.cyan, Colors.greenAccent],
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [0.2, 0.9])),
          ),
          leading: IconButton(
            icon: const Icon(
              Icons.close,
              size: 20,
              color: Colors.black,
            ),
            onPressed: () {
              Navigator.pop(context);
            },
          ),
        ),
        body: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.2, 0.9])),
          child: FutureBuilder<CV>(
              future: fetch.fetchCVById(widget.id),
              builder: (context, snapshot) {
                if (snapshot.hasData) {
                  return SingleChildScrollView(
                    child: Padding(
                      padding: const EdgeInsets.only(top: 8.0),
                      child: Stack(
                        children: [
                          Card(
                            margin: const EdgeInsets.only(
                                right: 15, left: 15, bottom: 30, top: 60),
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(10)),
                            color: Colors.black54,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                const SizedBox(
                                  height: 130,
                                ),
                                Center(
                                  child: Text(
                                    snapshot.data!.name,
                                    style: const TextStyle(
                                        color: Colors.white, fontSize: 24),
                                  ),
                                ),
                                const SizedBox(
                                  height: 8,
                                ),
                                Center(
                                  child: Text(
                                    snapshot.data!.specificationName,
                                    style: const TextStyle(
                                        color: Colors.white54, fontSize: 15),
                                  ),
                                ),
                                const SizedBox(height: 8),
                                const Divider(
                                  thickness: 1,
                                  color: Colors.grey,
                                ),
                                const SizedBox(height: 20),
                                const Padding(
                                  padding: EdgeInsets.all(10),
                                  child: Text("Account Information :",
                                      style: TextStyle(
                                          color: Colors.white54, fontSize: 22)),
                                ),
                                const SizedBox(
                                  height: 10,
                                ),
                                GestureDetector(
                                  onTap: () async {
                                    {
                                      final Uri url = Uri.parse(
                                          "tel:${snapshot.data!.phone}");

                                      if (!await launchUrl(url)) {
                                        throw Exception(
                                            'Could not launch ${snapshot.data!.phone}');
                                      }
                                    }
                                  },
                                  child: userInfo(
                                      myIcon: Icons.phone,
                                      content: snapshot.data!.phone),
                                ),
                                GestureDetector(
                                  onTap: () async {
                                    {
                                      final Uri url = Uri.parse(
                                          "mailto:${snapshot.data!.email}");

                                      if (!await launchUrl(url)) {
                                        throw Exception(
                                            'Could not launch ${snapshot.data!.email}');
                                      }
                                    }
                                  },
                                  child: userInfo(
                                      myIcon: Icons.email,
                                      content: snapshot.data!.email),
                                ),
                                userInfo(
                                    myIcon: Icons.home,
                                    content: snapshot.data!.address),
                                userInfo(
                                    myIcon: Icons.school,
                                    content: snapshot.data!.certificate),
                                const Divider(
                                  thickness: 1,
                                  color: Colors.grey,
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(8.0),
                                  child: Text(
                                    "Birthdate",
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 20,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    DateFormat.yMd()
                                        .format(snapshot.data!.birthdate),
                                    textAlign: TextAlign.justify,
                                    style: const TextStyle(
                                      color: Colors.white54,
                                      fontSize: 14,
                                    ),
                                  ),
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(8.0),
                                  child: Text(
                                    "Gender",
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 20,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    snapshot.data!.gender,
                                    style: const TextStyle(
                                      color: Colors.white54,
                                      fontSize: 14,
                                    ),
                                  ),
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(8.0),
                                  child: Text(
                                    "Stages",
                                    textAlign: TextAlign.justify,
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 20,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    snapshot.data!.stages.toString(),
                                    style: const TextStyle(
                                      color: Colors.white54,
                                      fontSize: 14,
                                    ),
                                  ),
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(8.0),
                                  child: Text(
                                    "Languages",
                                    textAlign: TextAlign.justify,
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 20,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    snapshot.data!.languages,
                                    textAlign: TextAlign.justify,
                                    style: const TextStyle(
                                      color: Colors.white54,
                                      fontSize: 14,
                                    ),
                                  ),
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(8.0),
                                  child: Text(
                                    "Previous works",
                                    textAlign: TextAlign.justify,
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 20,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Text(
                                    snapshot.data!.previousWorks,
                                    textAlign: TextAlign.justify,
                                    style: const TextStyle(
                                      color: Colors.white54,
                                      fontSize: 14,
                                    ),
                                  ),
                                ),
                                const SizedBox(
                                  height: 20,
                                ),
                                const Divider(
                                  height: 8,
                                  color: Colors.grey,
                                ),
                                const Padding(
                                  padding: EdgeInsets.all(12.0),
                                  child: Text(
                                    "Skills",
                                    style: TextStyle(
                                        color: Colors.white70,
                                        fontSize: 30,
                                        fontWeight: FontWeight.bold),
                                  ),
                                ),
                                GlobalMethods.buildListViewContainer(
                                    ListView.builder(
                                        itemCount: snapshot.data!.skills.length,
                                        itemBuilder: (context, index) => Column(
                                              children: [
                                                ListTile(
                                                  leading: CircleAvatar(
                                                    backgroundColor:
                                                        Colors.white,
                                                    radius: 20,
                                                    child: Center(
                                                        child: Text(
                                                      "${index + 1}",
                                                      style: const TextStyle(
                                                          color:
                                                              Colors.black54),
                                                    )),
                                                  ),
                                                  title: Text(
                                                    "${snapshot.data!.skills[index].name}    --     ${snapshot.data!.skills[index].practicePeriod}",
                                                    style: const TextStyle(
                                                        color: Colors.grey,
                                                        fontSize: 14),
                                                  ),
                                                ),
                                                const Divider(
                                                  color: Colors.grey,
                                                ),
                                              ],
                                            ))),
                              ],
                            ),
                          ),
                          Positioned(
                            top: 12,
                            left: size.width * 0.3,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Container(
                                  width: size.width * 0.4,
                                  height: size.width * 0.4,
                                  decoration: BoxDecoration(
                                    border: Border.all(
                                        width: 2, color: Colors.amber),
                                    shape: BoxShape.circle,
                                  ),
                                  child: ClipOval(
                                    child: Image.network(
                                      '$myUrl/${snapshot.data!.image}',
                                      fit: BoxFit.fill,
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          )
                        ],
                      ),
                    ),
                  );
                } else {
                  return const Center(child: CircularProgressIndicator());
                }
              }),
        ),
      ),
    );
  }

  Widget userInfo({required IconData myIcon, required String content}) {
    return Padding(
      padding: const EdgeInsets.all(10.0),
      child: Row(
        children: [
          Icon(myIcon, color: Colors.amber),
          const SizedBox(
            width: 10,
          ),
          Text(
            content,
            style: const TextStyle(color: Colors.white54),
          )
        ],
      ),
    );
  }
}
