import 'package:flutter/material.dart';
import 'package:job_portal_app/UI/Bottom_Navigation_Bar/company_navigation_bar.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Services/global_methods.dart';
import '../../UI/Common/change_your_password.dart';
import '../../data/Company/company.dart';
import 'edit_company_information_screen.dart';
import 'jobs_setting.dart';

class CompanySetting extends StatefulWidget {
  const CompanySetting({super.key});

  @override
  State<CompanySetting> createState() => _CompanySettingState();
}

class _CompanySettingState extends State<CompanySetting> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        bottomNavigationBar: CompanyNavigationBar(
          indexNum: 3,
        ),
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          flexibleSpace: Container(
            decoration: const BoxDecoration(
                gradient: LinearGradient(
                    colors: [Colors.cyan, Colors.greenAccent],
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [0.2, 0.9])),
          ),
          title: const Text("Setting"),
          centerTitle: true,
        ),
        body: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.2, 0.9])),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              GestureDetector(
                  onTap: () {
                    Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) => const JobsSetting()));
                  },
                  child: GlobalMethods.userInfo(
                      myIcon: Icons.settings, content: "Jobs Management")),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => FutureBuilder<Company>(
                        future: fetch.fetchCompany(),
                        builder: (context, snapshot) {
                          if (snapshot.connectionState ==
                              ConnectionState.waiting) {
                            return SafeArea(
                              child: Container(
                                  decoration: const BoxDecoration(
                                      gradient: LinearGradient(
                                          colors: [
                                            Colors.cyan,
                                            Colors.greenAccent
                                          ],
                                          begin: Alignment.centerLeft,
                                          end: Alignment.centerRight,
                                          stops: [0.2, 0.9])),
                                  child: const Center(
                                      child: CircularProgressIndicator())),
                            );
                          } else if (snapshot.hasError) {
                            return Text("Error: ${snapshot.error}");
                          } else {
                            return EditCompanyInformationScreen(
                                company: snapshot.data);
                          }
                        },
                      ),
                    ),
                  );
                },
                child: GlobalMethods.userInfo(
                    myIcon: Icons.settings,
                    content: "Company Infomation Setting"),
              ),
              GestureDetector(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => FutureBuilder<Company>(
                        future: fetch.fetchCompany(),
                        builder: (context, snapshot) {
                          if (snapshot.connectionState ==
                              ConnectionState.waiting) {
                            return SafeArea(
                              child: Container(
                                  decoration: const BoxDecoration(
                                      gradient: LinearGradient(
                                          colors: [
                                            Colors.cyan,
                                            Colors.greenAccent
                                          ],
                                          begin: Alignment.centerLeft,
                                          end: Alignment.centerRight,
                                          stops: [0.2, 0.9])),
                                  child: const Center(
                                      child: CircularProgressIndicator())),
                            );
                          } else if (snapshot.hasError) {
                            return Text("Error: ${snapshot.error}");
                          } else {
                            return const ChangeYourPassword();
                          }
                        },
                      ),
                    ),
                  );
                },
                child: GlobalMethods.userInfo(
                    myIcon: Icons.settings, content: "Change Your Password"),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
