﻿using JobPortalAPI.IRepository;

namespace JobPortalAPI.UnitOfWork
{
    public interface IUnitOfWork : IDisposable
    {
        public ICompanyRepository CompanyRepo { get; }
        public ICvRepository CvRepo { get; }
        public ICvSkillRepository CvSkillRepo { get; }
        public IInterviewRepository InterviewRepo { get; }
        public IJobRepository JobRepo { get; }
        public IJobEntryRepository JobEntryRepo { get; }
        public IJobSeekerRepository JobSeekerRepo { get; }
        public IJobSkillRepository JobSkillRepo { get; }

        public INotificationRepository NotificationRepo { get; }
        public IPersonRepository PersonRepo { get; }
        public ISkillRepository SkillRepo { get; }

        public ISpecificationRepository SpecificationRepo { get; }
        public int SaveChanges();



    }
}
