﻿using JobPortalAPI.IRepository;
using JobPortalAPI.Models;
using Microsoft.EntityFrameworkCore;
using System.Linq.Expressions;

namespace JobPortalAPI.Repository
{
    public class Repository<T> : IRepository<T> where T : class
    {
        protected readonly JobPortalDBContext Context;
        private DbSet<T> _dbSet;
        public Repository(JobPortalDBContext context)
        {
            Context = context;
            _dbSet = Context.Set<T>();
        }

        public T Get(int id)
        {
            return _dbSet.Find(id);
        }
        public IEnumerable<T> GetAll()
        {

            return _dbSet.ToList(); 

        }
        public IEnumerable<T> Find(Expression<Func<T, bool>> predicate)
        {
            return _dbSet.Where(predicate);
        }
        public void Add(T entity)
        {
            _dbSet.Add(entity);

            Context.SaveChanges();

        }
        public void AddRange(IEnumerable<T> entities)
        {
            _dbSet.AddRange(entities);

            Context.SaveChanges();
        }

        public void Update(T entity)
        {
            _dbSet.Update(entity);
        }

        public void Remove(T entity)
        {
            _dbSet.Remove(entity);
        }
        public void RemoveRange(IEnumerable<T> entities)
        {
            _dbSet.RemoveRange(entities);
        }

    }
}
