﻿using AutoMapper;
using JobPortalAPI.DTOs;
using JobPortalAPI.Models;

namespace JobPortalAPI.Helpers
{
    public class MappingProfile : Profile
    {
        public MappingProfile()
        {
            // from , to
            CreateMap<Person, PersonDto>();
            CreateMap<JobSeeker, JobSeekerDto>()
                    .ForMember(dest => dest.SpecificationName, opt => opt.MapFrom(src => src.Specification.Name))
                   .ForMember(dest => dest.Address, opt => opt.MapFrom(src => src.IdNavigation.Address))
                   .ForMember(dest => dest.Name, opt => opt.MapFrom(src => src.IdNavigation.Name))
                   .ForMember(dest => dest.Email, opt => opt.MapFrom(src => src.IdNavigation.Email))
                   .ForMember(dest => dest.Image, opt => opt.MapFrom(src => src.IdNavigation.Image))
                   .ForMember(dest => dest.Phone, opt => opt.MapFrom(src => src.IdNavigation.Phone));


            CreateMap<PersonJobSeekerDto, Cv>();
            CreateMap<Notification, NotificationDto>();
            CreateMap<BookInterviewDto, Interview>();
            CreateMap<Interview, InterviewDto>();
            CreateMap<PersonDto, Person>().ForMember(src => src.Image, opt => opt.Ignore());
            CreateMap<PersonJobSeekerDto, Person>()
                .ForMember(src => src.Image, opt => opt.Ignore());
            CreateMap<PersonCompanyDto, Person>()
               .ForMember(src => src.Image, opt => opt.Ignore());

            CreateMap<SkillDto, Skill>()
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => src.Name.ToUpper()));

            CreateMap<PersonJobSeekerDto, JobSeeker>()
                 .ForMember(dest => dest.Gender, opt => opt.MapFrom(src => src.Gender))
                 .ForMember(dest => dest.Birthdate, opt => opt.MapFrom(src => src.Birthdate));
            CreateMap<PersonCompanyDto, Company>()
                 .ForMember(dest => dest.Description, opt => opt.MapFrom(src => src.Description));
            CreateMap<JobDto, Job>();
           









        }
    }

}

