﻿using Microsoft.Build.Framework;
using System.ComponentModel.DataAnnotations;

namespace JobPortalAPI.DTOs
{
    public class LogInDto
    {
        [System.ComponentModel.DataAnnotations.Required]
        [DataType(DataType.EmailAddress)]
        [RegularExpression(@"^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$",
        ErrorMessage = "Invalid email format")]
        public String email { get; set; } 
        [System.ComponentModel.DataAnnotations.Required]
        [DataType(DataType.Password)]
        public String password { get; set; }
    }
}
