﻿using AutoMapper;
using JobPortalAPI.DTOs;
using JobPortalAPI.Models;
using JobPortalAPI.Notifications;
using JobPortalAPI.UnitOfWork;
using Microsoft.AspNetCore.Authentication.JwtBearer;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.SignalR;
using Microsoft.EntityFrameworkCore;

namespace JobPortalAPI.Controllers
{
    [Authorize(AuthenticationSchemes = JwtBearerDefaults.AuthenticationScheme)]

    [Route("api/[controller]")]
    [ApiController]
    public class NotificationsController : BaseController
    {
        private readonly IMapper _mapper;
        protected readonly JobPortalDBContext Context;
        private readonly UserManager<IdentityUser> _userManager;
        private readonly IHubContext<NotificationHub> _hubContext;

        private readonly IConfiguration _configuration;
        private DbSet<Notification> _dbSet;
        public NotificationsController(IUnitOfWork unitOfWork, IMapper mapper, JobPortalDBContext context, UserManager<IdentityUser> userManager, IConfiguration configuration, IHubContext<NotificationHub> hubContext)
        : base(unitOfWork)
        {
            _mapper = mapper;
            Context = context;
            _dbSet = Context.Set<Notification>();
            _userManager = userManager;
            _configuration = configuration;
            _hubContext = hubContext;

        }
        [HttpGet("GetCompanyNotificationById/{id}")]
        public IActionResult GetCompanyNotificationById(int id)
        {

            var notifications = _unitOfWork.NotificationRepo.GetAll().Where(n => n.CompanyId == id && n.ToCompany == true);
            if (notifications != null) 
            {

                List<NotificationDto> x = new List<NotificationDto>();
                NotificationDto y = new NotificationDto();
                foreach (var not in notifications)
                {
                    not.IsRead = true;
                    _unitOfWork.NotificationRepo.Update(not);
                    _unitOfWork.SaveChanges();
                    y = _mapper.Map<NotificationDto>(not);

                    var person = _unitOfWork.PersonRepo.Get(not.JobSeekerId);
                    y.Name = person.Name;

                    var filePath = Path.Combine("Images", person.Image);
                 

                    y.Image = filePath;
                    x.Add(y);
                }

                   List<NotificationDto> z = new List<NotificationDto>();
                for(int i = x.Count - 1 ; i >= 0; i--)
                {
                    z.Add(x[i]);
                }

                return Ok(z);            }
            else
            {
                return NotFound("you don't have any notifications");
            }
        }
        [HttpGet("GetJobseekerNotificationById/{id}")]
        public IActionResult GetJobseekerNotificationById(int id)
        {

            var notifications = _unitOfWork.NotificationRepo.GetAll().Where(n => n.JobSeekerId == id && n.ToCompany== false);
           

            if (notifications != null)
            {

                List<NotificationDto> x = new List<NotificationDto>();
                NotificationDto y = new NotificationDto();
                foreach (var not in notifications)
                {
                    not.IsRead = true;
                    _unitOfWork.NotificationRepo.Update(not);
                    _unitOfWork.SaveChanges();
                    y = _mapper.Map<NotificationDto>(not);
                    var person = _unitOfWork.PersonRepo.Get(not.CompanyId);
                    y.Name = person.Name;

                    //string currentDirectory = Directory.GetCurrentDirectory();
                    var filePath = Path.Combine("Images", person.Image);
                    //var fullPath = Path.Combine(currentDirectory, filePath);
                    //byte[] myimage = System.IO.File.ReadAllBytes(fullPath);

                    y.Image = filePath;
                    x.Add(y);
                }
                List<NotificationDto> z = new List<NotificationDto>();
                for(int i = x.Count - 1 ; i >= 0; i--)
                {
                    z.Add(x[i]);
                }

                return Ok(z);
            }
            else
            {
                return NotFound("you don't have any notifications");
            }
        }
        [HttpGet("GetNumberOfCompanyNotifications/{id}")]
        public IActionResult GetNumberOfCompanyNotifications(int id)
        {
            var entries = _unitOfWork.NotificationRepo.GetAll().Where(e => e.CompanyId == id && e.IsRead == false && e.ToCompany==true);

            int x = entries.Count();
            return Ok(x);
        }
        [HttpGet("GetNumberOfJobseekerNotifications/{id}")]
        public IActionResult GetNumberOfJobseekerNotifications(int id)
        {
            var entries = _unitOfWork.NotificationRepo.GetAll().Where(e => e.JobSeekerId == id && e.IsRead == false && e.ToCompany == false);

            int x = entries.Count();
            return Ok(x);
        }

    }
}
