﻿using JobPortalAPI.Models;
using System.Linq.Expressions;

namespace JobPortalAPI.IRepository
{
    public interface IRepository<T> where T : class
    {
        // Finding Objects
        T Get(int id);
        IEnumerable<T> GetAll();
        IEnumerable<T> Find(Expression<Func<T, bool>> predicate);

        // Adding Objects
        void Add(T entity);
        void AddRange(IEnumerable<T> entities);

        void Update(T entity);

        // Removing Objects
        void Remove(T entity);
        void RemoveRange(IEnumerable<T> entities);
    }
}
