﻿using JobPortalAPI.IRepository;
using JobPortalAPI.Models;
using Microsoft.EntityFrameworkCore;

namespace JobPortalAPI.Repository
{
    public class CvRepository : Repository<Cv>, ICvRepository
    {
        public CvRepository(JobPortalDBContext context) : base(context)
        {
        }
        public JobPortalDBContext CurrDbContext
        {
            get { return Context as JobPortalDBContext; }    
        }

        public Cv GetAllCvDetails(int id)
        {
            var x = Context.Cvs.Include(c => c.IdNavigation).Include(c => c.Cvskills).FirstOrDefault(c => c.Id == id);
            return x;
        }
        public List<Cv> GetAllCvsDetails()
        {
            var x = Context.Cvs.Include(c => c.IdNavigation).Include(c => c.Cvskills).ToList();
            return x;
        }
    }
}
