﻿using Microsoft.AspNetCore.SignalR;

namespace JobPortalAPI.Notifications
{
    public class NotificationHub : Hub
    {
        public async Task SendNotification(string message)
        {
            await Clients.All.SendAsync("ReceiveNotification", message);

        }
        public async Task AssociateUser(string[] args)
        {
            string userId = args[0]; 
            await Groups.AddToGroupAsync(Context.ConnectionId, userId);
        }
        public async Task SendNotificationToUser(string userId, string message)
        {
            // Send the notification to the specified user
            await Clients.Group(userId).SendAsync("ReceiveNotification", message);
        }
        public async Task JoinGroup(string groupName)
        {
            await Groups.AddToGroupAsync(Context.ConnectionId, groupName);
        }
    }
}
