﻿using JobPortalAPI.IRepository;
using JobPortalAPI.Models;
using JobPortalAPI.Repository;

namespace JobPortalAPI.UnitOfWork
{
    public class UnitOfWork : IUnitOfWork
    {
        public readonly JobPortalDBContext _context;
        public ICompanyRepository CompanyRepo { get; private set; }
        public ICvRepository CvRepo { get; private set; }
        public ICvSkillRepository CvSkillRepo { get; private set; }
        public IInterviewRepository InterviewRepo { get; private set; }
        public IJobRepository JobRepo { get; private set; }
        public IJobEntryRepository JobEntryRepo { get; private set; }
        public IJobSeekerRepository JobSeekerRepo { get; private set; }
        public IJobSkillRepository JobSkillRepo { get; private set; }

        public INotificationRepository NotificationRepo { get; private set; }
        public IPersonRepository PersonRepo { get; private set; }
        public ISkillRepository SkillRepo { get; private set;
        }

        public ISpecificationRepository SpecificationRepo { get; private set; }
        public UnitOfWork(JobPortalDBContext context)
        {
            _context = context;

            CompanyRepo = new CompanyRepository(_context);
            CvRepo = new CvRepository(_context);
            CvSkillRepo = new CvSkillRepository(_context);
            InterviewRepo = new InterviewRepository(_context);
            JobRepo = new JobRepository(_context);
            JobSkillRepo = new JobSkillRepository(_context);
            JobEntryRepo = new JobEntryRepository(_context);
            JobSeekerRepo = new JobSeekerRepository(_context);
            NotificationRepo = new NotificationRepository(_context);
            SpecificationRepo = new SpecificationRepository(_context);
            SkillRepo = new SkillRepository(_context);
            PersonRepo = new PersonRepository(_context);

        }
        public int SaveChanges()
        {
            return _context.SaveChanges();
        }

        public void Dispose()
        {
            _context.Dispose();
        }
    }
}
