﻿using JobPortalAPI.DTOs;
using JobPortalAPI.IRepository;
using JobPortalAPI.Models;
using Microsoft.EntityFrameworkCore;

namespace JobPortalAPI.Repository
{
    public class JobSeekerRepository : Repository<JobSeeker>, IJobSeekerRepository
    {
        public JobSeekerRepository(JobPortalDBContext context) : base(context)
        {
        }
        public JobPortalDBContext CurrDbContext
        {
            get { return Context as JobPortalDBContext; }     
        }

        public List<JobSeeker> GetAllDetails()
        {
            var x =  Context.JobSeekers.Include(js => js.IdNavigation).Include(js => js.Specification).ToList();
            return  x;
        }
        public IEnumerable<JobSeeker> GetAllWithSpecification()
        {
            return Context.JobSeekers.Include(j => j.Specification);
        }
    }
}
