import 'dart:convert';
import 'dart:io';
import 'package:http/http.dart' as http;
import 'package:job_portal_app/data/Common/my_notification.dart';
import 'package:job_portal_app/data/jobseeker/cv.dart';
import 'package:job_portal_app/data/Common/job.dart';
import 'package:job_portal_app/Logic/from_json.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import '../data/Common/interview.dart';
import '../data/Common/person.dart';
import '../data/Common/specification.dart';
import '../data/Company/company.dart';

// ignore: camel_case_types
class fetch {
  static Future<CV> fetchCV() async {
    final response = await http
        .get(Uri.parse('$myUrl/api/CVs/id?id=${identifier.id}'), headers: {
      HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
    });
    if (response.statusCode == 200) {
      return fromJson.toCv(jsonDecode(response.body));
    } else {
      throw Exception('Failed to load CV');
    }
  }

  static Future<Company> fetchCompany() async {
    final response = await http.get(
        Uri.parse('$myUrl/api/Companies/id?id=${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toCompany(jsonDecode(response.body));
    } else {
      throw Exception('Failed to load Company');
    }
  }

  static Future<Company> fetchCompanyById(int id) async {
    final response = await http.get(Uri.parse('$myUrl/api/Companies/id?id=$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toCompany(jsonDecode(response.body));
    } else {
      throw Exception('Failed to load Company');
    }
  }

  static Future<List<Job>> getAllJobs() async {
    final response = await http.get(Uri.parse('$myUrl/api/Jobs'), headers: {
      HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
    });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<Job> jobDetails =
          jsonList.map((json) => Job.fromJson(json)).toList();

      return jobDetails;
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  static Future<Job> getJobById(int id) async {
    final response = await http.get(Uri.parse('$myUrl/api/Jobs/id?id=$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toJob(jsonDecode(response.body));
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  static Future<List<Job>> getAllJobsByCompanyId() async {
    final response = await http.get(
        Uri.parse('$myUrl/api/Jobs/GetAllJobsByCompanyId?id=${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<Job> jobDetails =
          jsonList.map((json) => Job.fromJson(json)).toList();

      return jobDetails;
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  static Future<List<Job>> getAllJobsByJobseekerId() async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Jobs/GetAllJobsByJobseekerId?id=${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<Job> jobDetails =
          jsonList.map((json) => Job.fromJson(json)).toList();

      return jobDetails;
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  static Future<int> getNumberOfJobseekerSync(int id) async {
    final response = await http
        .get(Uri.parse('$myUrl/api/Jobs/GetNumberOfJobSeekers/$id'), headers: {
      HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
    });
    if (response.statusCode == 200) {
      final int number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed to get number of jobseeker');
    }
  }

  static Future<int> getNumberOfInterviewsByJobId(int id) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/Interviews/getNumberOfInterviewsByJobId/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final int number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed to get number of jobseeker');
    }
  }

  static Future<int> getNumberOfInterviewsByJobseekerId(int id) async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Interviews/getNumberOfInterviewsByJobseekerId/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final int number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed to get number of jobseeker');
    }
  }

  static Future<int> getNumberOfCompanyNotifications(int id) async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Notifications/GetNumberOfCompanyNotifications/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final int number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed to get number of jobseeker');
    }
  }

  static Future<bool> checkIfApplied(int id) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/JobSeekers/isApplied/$id/${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final bool number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed');
    }
  }

  static Future<Interview> checkIfBooked(int jobId, int jobseekerId) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/JobSeekers/isBooked/$jobId/$jobseekerId'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toInterview(jsonDecode(response.body));
    } else {
      throw Exception('Failed');
    }
  }

  static Future<List<Specification>> getAllSpecifications() async {
    final response = await http.get(Uri.parse('$myUrl/api/Specifications'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<Specification> specifications =
          jsonList.map((json) => Specification.fromJson(json)).toList();
      return specifications;
    } else {
      throw Exception('Failed to get specifications');
    }
  }

  static Future<List<MyNotification>> getAllNotificationByCompanyId() async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Notifications/GetCompanyNotificationById/${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });

    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<MyNotification> notificationDetails =
          jsonList.map((json) => MyNotification.fromJson(json)).toList();
      return notificationDetails;
    } else {
      throw Exception('Failed to load notifications');
    }
  }

  static Future<List<MyNotification>> getAllNotificationByJobseekerId() async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Notifications/GetJobseekerNotificationById/${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });

    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<MyNotification> notificationDetails =
          jsonList.map((json) => MyNotification.fromJson(json)).toList();
      return notificationDetails;
    } else {
      throw Exception('Failed to load notifications');
    }
  }

  static Future<CV> fetchCVById(int id) async {
    final response = await http.get(Uri.parse('$myUrl/api/CVs/id?id=$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toCv(jsonDecode(response.body));
    } else {
      throw Exception('Failed to load CV');
    }
  }

  static Future<List<CV>> getAllApplicants(int id) async {
    final response = await http
        .get(Uri.parse('$myUrl/api/CVs/GetAllApplicants/$id'), headers: {
      HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
    });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<CV> cvsDetails =
          jsonList.map((json) => CV.fromJson(json)).toList();
      return cvsDetails;
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  static Future<List<CV>> getAllJobseekers() async {
    final response = await http.get(Uri.parse('$myUrl/api/CVs'), headers: {
      HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
    });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);
      final List<CV> cvsDetails =
          jsonList.map((json) => CV.fromJson(json)).toList();
      return cvsDetails;
    } else {
      throw Exception('Failed to load jobseekers');
    }
  }

  static Future<List<Company>> getAllCompanies() async {
    final response = await http.get(Uri.parse('$myUrl/api/Companies'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });

    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);

      final List<Company> companiesDetails =
          jsonList.map((json) => fromJson.toCompany(json)).toList();
      return companiesDetails;
    } else {
      throw Exception('Failed to load companies');
    }
  }

  static Future<List<Interview>> getAllInterviewsByJobId(int id) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/Interviews/getAllInterviewsByJobId/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });

    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);

      final List<Interview> interviewsDetails =
          jsonList.map((json) => fromJson.toInterview(json)).toList();

      return interviewsDetails;
    } else {
      throw Exception('Failed to load interviews');
    }
  }

  static Future<int> getNumberOfJobseekerNotifications(int id) async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Notifications/GetNumberOfJobseekerNotifications/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final int number = json.decode(response.body);
      return number;
    } else {
      throw Exception('Failed to get number of jobseeker');
    }
  }

  static Future<List<Interview>> getAllInterviewsByJobseekerId() async {
    final response = await http.get(
        Uri.parse(
            '$myUrl/api/Interviews/getAllInterviewsByJobseekerId/${identifier.id}'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      final List<dynamic> jsonList = json.decode(response.body);

      final List<Interview> interviewsDetails =
          jsonList.map((json) => fromJson.toInterview(json)).toList();

      return interviewsDetails;
    } else {
      throw Exception('Failed to load interviews');
    }
  }

  static Future<String> getJobseekerNameById(int id) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/JobSeekers/GetJobseekerNameById/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      String name = response.body.toString();
      return name;
    } else {
      throw Exception('Failed to get jobseeker name');
    }
  }

  static Future<String> getCompanyNameById(int id) async {
    final response = await http.get(
        Uri.parse('$myUrl/api/Companies/GetCompanyNameById/id?id=$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      String name = response.body.toString();
      return name;
    } else {
      throw Exception('Failed to get company name');
    }
  }

  static Future<Person> getPersonById(int id) async {
    final response = await http.get(Uri.parse('$myUrl/api/Persons/$id'),
        headers: {
          HttpHeaders.authorizationHeader: "Bearer ${identifier.token}"
        });
    if (response.statusCode == 200) {
      return fromJson.toPerson(jsonDecode(response.body));
    } else {
      throw Exception('Failed to get company name');
    }
  }
}
