import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_methods.dart';

import '../../data/Common/job.dart';
import 'update_job_information.dart';
import 'update_job_skills.dart';

class JobsManagment extends StatefulWidget {
  final Job job;

  const JobsManagment({super.key, required this.job});

  @override
  State<JobsManagment> createState() => _JobsManagmentState();
}

class _JobsManagmentState extends State<JobsManagment> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          leading: IconButton(
            icon: const Icon(
              Icons.close,
              size: 25,
              color: Colors.black,
            ),
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          flexibleSpace: Container(
            decoration: const BoxDecoration(
                gradient: LinearGradient(
                    colors: [Colors.cyan, Colors.greenAccent],
                    begin: Alignment.centerLeft,
                    end: Alignment.centerRight,
                    stops: [0.2, 0.9])),
          ),
          title: const Text("Jobs Managment"),
          centerTitle: true,
        ),
        body: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.2, 0.9])),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              GestureDetector(
                  onTap: () {
                    Navigator.push(
                        context,
                        MaterialPageRoute(
                            builder: (context) =>
                                UpdateJobInformation(job: widget.job)));
                  },
                  child: GlobalMethods.userInfo(
                      myIcon: Icons.settings,
                      content: "Update Job Information")),
              GestureDetector(
                onTap: () async {
                  await Navigator.push(
                      context,
                      MaterialPageRoute(
                          builder: (context) =>
                              UpdateJobSkills(id: widget.job.id)));
                },
                child: GlobalMethods.userInfo(
                    myIcon: Icons.settings, content: "Update Job Skills"),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
