// ignore_for_file: file_names

import 'package:curved_navigation_bar/curved_navigation_bar.dart';
import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_methods.dart';

import '../Company/company_home_screen.dart';
import '../Company/company_profile_screen.dart';
import '../Company/company_setting_screen.dart';
import '../Company/show_all_jobs_screen.dart';
import '../Company/upload_job_screen.dart';

// ignore: must_be_immutable
class CompanyNavigationBar extends StatelessWidget {
  int indexNum = 0;

  CompanyNavigationBar({super.key, required this.indexNum});

  @override
  Widget build(BuildContext context) {
    return CurvedNavigationBar(
      index: indexNum,
      height: 55,
      animationDuration: const Duration(milliseconds: 300),
      animationCurve: Curves.bounceInOut,
      onTap: (index) {
        if (index == 0) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const CompanyHomeScreen()));
        } else if (index == 1) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const ShowAllJobsScreen()));
        } else if (index == 2) {
          Navigator.pushReplacement(
              context,
              MaterialPageRoute(
                  builder: (context) => const CompanyProfileScreen()));
        } else if (index == 3) {
          Navigator.pushReplacement(context,
              MaterialPageRoute(builder: (context) => const CompanySetting()));
        } else if (index == 4) {
          Navigator.pushReplacement(context,
              MaterialPageRoute(builder: (context) => const UploadJobScreen()));
        } else if (index == 5) {
          GlobalMethods.logout(context);
        }
      },
      items: const [
        Icon(
          Icons.home,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.search,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.person_pin,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.settings,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.add,
          size: 19,
          color: Colors.black87,
        ),
        Icon(
          Icons.logout,
          size: 19,
          color: Colors.black87,
        )
      ],
      backgroundColor: Colors.green,
      buttonBackgroundColor: Colors.cyan.shade100,
      color: Colors.cyan.shade200,
    );
  }
}
