import 'package:flutter/material.dart';
import 'package:job_portal_app/Logic/fetch.dart';
import 'package:job_portal_app/Widgets/my_notification_widget.dart';
import 'package:job_portal_app/data/Common/my_notification.dart';

import '../../Services/global_methods.dart';

class SearchInMyNotificationsScreen extends StatefulWidget {
  const SearchInMyNotificationsScreen({super.key});

  @override
  State<SearchInMyNotificationsScreen> createState() =>
      _SearchInMyNotificationsScreenState();
}

class _SearchInMyNotificationsScreenState
    extends State<SearchInMyNotificationsScreen> {
  List<MyNotification> notificationsList = [];
  List<MyNotification> filteredNotifications = [];
  final TextEditingController _search = TextEditingController();
  String searchQuery = "Search query";

  @override
  void initState() {
    super.initState();
    _loadNotifications();
  }

  void _loadNotifications() async {
    try {
      List<MyNotification> fetchedNotifications =
          await fetch.getAllNotificationByJobseekerId();
      setState(() {
        notificationsList = fetchedNotifications;
      });
    } catch (error) {
      GlobalMethods.showErrorDialog(ctx: context, error: error.toString());
    }
  }

  Widget _searchField() {
    return TextField(
      controller: _search,
      autocorrect: true,
      decoration: const InputDecoration(
          border: InputBorder.none,
          hintText: "Search for notifications....",
          hintStyle: TextStyle(color: Colors.white)),
      style: const TextStyle(color: Colors.white, fontSize: 16.0),
      onChanged: (query) => _updateSearch(query),
    );
  }

  List<Widget> _buildActions() {
    return <Widget>[
      IconButton(
          onPressed: () {
            _clearSearch();
          },
          icon: const Icon(Icons.clear))
    ];
  }

  void _clearSearch() {
    setState(() {
      _search.clear();
      _updateSearch("");
    });
  }

  void _updateSearch(String newQuery) {
    setState(() {
      searchQuery = newQuery;
      filteredNotifications = notificationsList
          .where((notification) => notification.name
              .toLowerCase()
              .contains(searchQuery.toLowerCase()))
          .toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.1, 1])),
          child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              title: _searchField(),
              actions: _buildActions(),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
            ),
            body: ListView.builder(
              itemCount: filteredNotifications.length,
              itemBuilder: (context, index) {
                return MyNotificationWidget(
                    notification: filteredNotifications[index]);
              },
            ),
          )),
    );
  }
}
