import 'package:flutter/material.dart';
import 'package:job_portal_app/Logic/fetch.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/UI/Bottom_Navigation_Bar/bottom_navigation_bar.dart';
import 'package:provider/provider.dart';

import '../../Services/Common/new_notification_manager.dart';
import '../../Services/global_methods.dart';
import '../../Widgets/app_drawer_widget.dart';
import '../../data/Common/person.dart';
import '../Notification/show_jobseekers_notification_screen.dart';

class JobSeekerHomeScreen extends StatefulWidget {
  const JobSeekerHomeScreen({super.key});

  @override
  State<JobSeekerHomeScreen> createState() => _JobSeekerHomeScreenState();
}

class _JobSeekerHomeScreenState extends State<JobSeekerHomeScreen> {
  Person person = Person("", "", "");
  int y = 0;
  int x = 0;

  @override
  void initState() {
    super.initState();
    fetchPerson();
    fetchData();
  }

  Future<void> fetchPerson() async {
    try {
      y = identifier.id;
      person = await fetch.getPersonById(y);
      setState(() {});
    } catch (error) {
      GlobalMethods.showErrorDialog(error: error.toString(), ctx: context);
    }
    setState(() {});
  }

  Future<void> fetchData() async {
    try {
      y = identifier.id;
      x = await fetch.getNumberOfJobseekerNotifications(y);
      setState(() {});
    } catch (error) {
      GlobalMethods.showErrorDialog(error: error.toString(), ctx: context);
    }
    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          gradient: LinearGradient(
              colors: [Colors.cyan, Colors.greenAccent],
              begin: Alignment.centerLeft,
              end: Alignment.centerRight,
              stops: [0.1, 1])),
      child: SafeArea(
        child: Scaffold(
          bottomNavigationBar: MyBottomNavigationBar(
            indexNum: 0,
          ),
          backgroundColor: Colors.transparent,
          drawer: AppDrawerWidget(
            person: person,
          ),
          appBar: AppBar(
            iconTheme: const IconThemeData(color: Colors.black),
            actions: [
              Consumer<NewNotificationManager>(
                  builder: (context, notificationManager, _) {
                return InkWell(
                    onTap: () async {
                      notificationManager.jobseekerDismiss();
                      await Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (context) =>
                              const ShowJobseekersNotificationScreen(),
                        ),
                      );
                      setState(() {
                        fetchData();
                      });
                    },
                    child: Stack(children: [
                      const Padding(
                        padding: EdgeInsets.all(8.0),
                        child: Icon(
                          Icons.notifications,
                          size: 40,
                          color: Colors.black87,
                        ),
                      ),
                      notificationManager.hasJobseekerNewNotification == true ||
                              x > 0
                          ? Positioned(
                              right: 8,
                              bottom: 12,
                              child: Container(
                                width: 17,
                                height: 17,
                                decoration: const BoxDecoration(
                                  color: Colors.red,
                                  shape: BoxShape.circle,
                                ),
                                child: Padding(
                                  padding: const EdgeInsets.all(1.0),
                                  child: Text(
                                    notificationManager
                                                .jobseekerNotificationCount !=
                                            0
                                        ? notificationManager
                                            .jobseekerNotificationCount
                                            .toString()
                                        : x.toString(),
                                    textAlign: TextAlign.center,
                                    style: const TextStyle(
                                        color: Colors.white, fontSize: 9),
                                  ),
                                ),
                              ))
                          : const SizedBox.shrink()
                    ]));
              })
            ],
            flexibleSpace: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.2, 0.9])),
            ),
          ),
          body: SingleChildScrollView(
              child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Card(
              color: Colors.black45,
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(15)),
              child: Column(
                children: [
                  ClipRRect(
                    borderRadius: const BorderRadius.only(
                      topLeft: Radius.circular(15),
                      topRight: Radius.circular(15),
                    ),
                    child: Image.asset("Images/home.jpg"),
                  ),
                  Center(
                    child: Padding(
                      padding: const EdgeInsets.all(8.0),
                      child: Text(
                        "Hello ${person.name.toString()}",
                        style: const TextStyle(
                            color: Colors.amberAccent,
                            fontSize: 30,
                            fontStyle: FontStyle.italic),
                      ),
                    ),
                  ),
                  const Divider(
                    thickness: 1,
                    color: Colors.amber,
                  ),
                  const Padding(
                    padding: EdgeInsets.all(8.0),
                    child: Text(
                      "The job portal application helps job seekers find the most suitable job for them, as it allows a review of all the jobs offered in the application, in addition to the ability to search for a specific job, apply for it, and request an appointment for an interview.",
                      textAlign: TextAlign.justify,
                      style: TextStyle(
                          color: Colors.white54,
                          fontSize: 18,
                          fontStyle: FontStyle.italic),
                    ),
                  ),
                  GlobalMethods.showDashBoard(context),
                ],
              ),
            ),
          )),
        ),
      ),
    );
  }
}
