import 'package:flutter/material.dart';
import 'package:job_portal_app/Logic/fetch.dart';
import 'package:job_portal_app/Services/global_methods.dart';

import '../../Widgets/applicants_widget.dart';
import '../../data/jobseeker/cv.dart';

// ignore: must_be_immutable
class SearchForApplicantScreen extends StatefulWidget {
  int id;
  int companyId;

  SearchForApplicantScreen(
      {super.key, required this.companyId, required this.id});

  @override
  State<SearchForApplicantScreen> createState() =>
      _SearchForApplicantScreenState();
}

class _SearchForApplicantScreenState extends State<SearchForApplicantScreen> {
  List<CV> applicantsList = [];
  List<CV> filteredApplicants = [];
  final TextEditingController _search = TextEditingController();
  String searchQuery = "Search query";

  @override
  void initState() {
    super.initState();
    _loadApplicants();
  }

  void _loadApplicants() async {
    try {
      List<CV> fetchedApplicants = await fetch.getAllApplicants(widget.id);
      setState(() {
        applicantsList = fetchedApplicants;
      });
    } catch (error) {
      GlobalMethods.showErrorDialog(ctx: context, error: error.toString());
    }
  }

  Widget _searchField() {
    return TextField(
      controller: _search,
      autocorrect: true,
      decoration: const InputDecoration(
          border: InputBorder.none,
          hintText: "Search for applicants....",
          hintStyle: TextStyle(color: Colors.white)),
      style: const TextStyle(color: Colors.white, fontSize: 16.0),
      onChanged: (query) => _updateSearch(query),
    );
  }

  List<Widget> _buildActions() {
    return <Widget>[
      IconButton(
          onPressed: () {
            _clearSearch();
          },
          icon: const Icon(Icons.clear))
    ];
  }

  void _clearSearch() {
    setState(() {
      _search.clear();
      _updateSearch("");
    });
  }

  void _updateSearch(String newQuery) {
    setState(() {
      searchQuery = newQuery;
      filteredApplicants = applicantsList
          .where((applicant) =>
              applicant.name.toLowerCase().contains(searchQuery.toLowerCase()))
          .toList();
    });
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
          decoration: const BoxDecoration(
              gradient: LinearGradient(
                  colors: [Colors.cyan, Colors.greenAccent],
                  begin: Alignment.centerLeft,
                  end: Alignment.centerRight,
                  stops: [0.1, 1])),
          child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              title: _searchField(),
              actions: _buildActions(),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
            ),
            body: ListView.builder(
              itemCount: filteredApplicants.length,
              itemBuilder: (context, index) {
                return ApplicantsWidget(
                    cv: filteredApplicants[index],
                    jobId: widget.id,
                    companyId: widget.companyId);
              },
            ),
          )),
    );
  }
}
