import 'package:flutter/material.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Widgets/job_setting_widget.dart';
import '../../data/Common/job.dart';
import 'search_in_my_jobs_screen.dart';

class JobsSetting extends StatefulWidget {
  const JobsSetting({super.key});

  @override
  State<JobsSetting> createState() => _JobsSettingState();
}

class _JobsSettingState extends State<JobsSetting> {
  Future<List<Job>>? _futureJobs;

  @override
  void initState() {
    _futureJobs = fetch.getAllJobsByCompanyId();
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              actions: [
                Padding(
                  padding: const EdgeInsets.only(right: 8.0),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      IconButton(
                        icon: const Icon(
                          Icons.search,
                          size: 25,
                          color: Colors.black,
                        ),
                        onPressed: () {
                          Navigator.push(
                              context,
                              MaterialPageRoute(
                                  builder: (context) =>
                                      const SearchInMyJobsScreen()));
                        },
                      ),
                    ],
                  ),
                ),
              ],
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 25,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              title: const Text("Jobs Management"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder(
                future: _futureJobs,
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<Job>? jobs = snapshot.data;
                    return ListView.builder(
                      itemCount: jobs!.length,
                      itemBuilder: (context, index) {
                        Job job = jobs[index];
                        return JobSettingWidget(job: job);
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
