import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_methods.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/Common/person.dart';
import 'package:provider/provider.dart';

import '../../Services/Common/new_notification_manager.dart';
import '../../Widgets/app_drawer_widget.dart';
import '../../logic/fetch.dart';
import '../Bottom_Navigation_Bar/company_navigation_bar.dart';
import '../Notification/show_my_notification_screen.dart';

class CompanyHomeScreen extends StatefulWidget {
  const CompanyHomeScreen({super.key});

  @override
  State<CompanyHomeScreen> createState() => _CompanyHomeScreenState();
}

class _CompanyHomeScreenState extends State<CompanyHomeScreen> {
  int y = 0;
  int x = 0;
  Person person = Person("", "", "");

  @override
  void initState() {
    fetchPerson();
    fetchData();
    super.initState();
  }

  Future<void> fetchPerson() async {
    try {
      y = identifier.id;
      person = await fetch.getPersonById(y);
      setState(() {});
    } catch (error) {
      GlobalMethods.showErrorDialog(error: error.toString(), ctx: context);
    }
    setState(() {});
  }

  Future<void> fetchData() async {
    try {
      y = identifier.id;
      x = await fetch.getNumberOfCompanyNotifications(y);
    } catch (error) {
      GlobalMethods.showErrorDialog(error: error.toString(), ctx: context);
    }
    setState(() {});
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Container(
        decoration: const BoxDecoration(
            gradient: LinearGradient(
                colors: [Colors.cyan, Colors.greenAccent],
                begin: Alignment.centerLeft,
                end: Alignment.centerRight,
                stops: [0.1, 1])),
        child: Scaffold(
          bottomNavigationBar: CompanyNavigationBar(
            indexNum: 0,
          ),
          backgroundColor: Colors.transparent,
          drawer: AppDrawerWidget(
            person: person,
          ),
          appBar: AppBar(
            iconTheme: const IconThemeData(
              color: Colors.black, // Set the desired icon color
            ),
            actions: [
              Consumer<NewNotificationManager>(
                  builder: (context, notificationManager, _) {
                return InkWell(
                    onTap: () async {
                      notificationManager.dismiss();

                      await Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (context) =>
                              const ShowMyNotificationScreen(),
                        ),
                      );
                      setState(() {
                        fetchData();
                      });
                    },
                    child: Stack(children: [
                      const Padding(
                        padding: EdgeInsets.all(8.0),
                        child: Icon(
                          Icons.notifications,
                          size: 40,
                          color: Colors.black87,
                        ),
                      ),
                      notificationManager.hasNewNotification == true || x > 0
                          ? Positioned(
                              right: 8,
                              bottom: 12,
                              child: Container(
                                width: 17,
                                height: 17,
                                decoration: const BoxDecoration(
                                  color: Colors.red,
                                  shape: BoxShape.circle,
                                ),
                                child: Padding(
                                  padding: const EdgeInsets.all(1.0),
                                  child: Text(
                                    notificationManager.notificationCount != 0
                                        ? notificationManager.notificationCount
                                            .toString()
                                        : x.toString(),
                                    textAlign: TextAlign.center,
                                    style: const TextStyle(
                                        color: Colors.white, fontSize: 9),
                                  ),
                                ),
                              ))
                          : const SizedBox.shrink()
                    ]));
              })
            ],
            flexibleSpace: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.2, 0.9])),
            ),
          ),
          body: SingleChildScrollView(
              child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Card(
              color: Colors.black45,
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(15)),
              child: Column(
                children: [
                  ClipRRect(
                    borderRadius: const BorderRadius.only(
                      topLeft: Radius.circular(15),
                      topRight: Radius.circular(15),
                    ),
                    child: Image.asset("Images/comphome.jpg"),
                  ),
                  Center(
                    child: Padding(
                      padding: const EdgeInsets.all(8.0),
                      child: Text(
                        "Hello ${person.name.toString()}",
                        style: const TextStyle(
                            color: Colors.amberAccent,
                            fontSize: 30,
                            fontStyle: FontStyle.italic),
                      ),
                    ),
                  ),
                  const Divider(
                    thickness: 1,
                    color: Colors.amber,
                  ),
                  const Padding(
                    padding: EdgeInsets.all(8.0),
                    child: Text(
                      "The job portal application helps companies find the most suitable job seekers for the jobs they offer, as it allows the possibility of adding a new job, receiving employment applications submitted by job seekers, in addition to booking appointments for interviews for applicants.",
                      textAlign: TextAlign.justify,
                      style: TextStyle(
                          color: Colors.white54,
                          fontSize: 18,
                          fontStyle: FontStyle.italic),
                    ),
                  ),
                  GlobalMethods.showDashBoard(context),
                ],
              ),
            ),
          )),
        ),
      ),
    );
  }
}
