import 'package:flutter/material.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Widgets/applicants_widget.dart';
import '../../data/jobseeker/cv.dart';
import 'search_for_applicant_screen.dart';

// ignore: must_be_immutable
class ShowApplicantsScreen extends StatefulWidget {
  int id;
  int companyId;

  ShowApplicantsScreen({super.key, required this.id, required this.companyId});

  @override
  State<ShowApplicantsScreen> createState() => _ShowApplicantsScreenState();
}

class _ShowApplicantsScreenState extends State<ShowApplicantsScreen> {
  Future<List<CV>>? _futureCVs;

  @override
  void initState() {
    _futureCVs = fetch.getAllApplicants(widget.id);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              actions: [
                Padding(
                  padding: const EdgeInsets.only(right: 8.0),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      IconButton(
                        icon: const Icon(
                          Icons.search,
                          size: 25,
                          color: Colors.black,
                        ),
                        onPressed: () {
                          Navigator.push(
                              context,
                              MaterialPageRoute(
                                  builder: (context) =>
                                      SearchForApplicantScreen(
                                          id: widget.id,
                                          companyId: widget.companyId)));
                        },
                      ),
                    ],
                  ),
                ),
              ],
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 25,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              title: const Text("Job Applicants"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder(
                future: _futureCVs,
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<CV>? cvs = snapshot.data;
                    return ListView.builder(
                      itemCount: cvs!.length,
                      itemBuilder: (context, index) {
                        CV cv = cvs[index];
                        return ApplicantsWidget(
                          cv: cv,
                          companyId: widget.companyId,
                          jobId: widget.id,
                        );
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
