import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:url_launcher/url_launcher.dart';

import '../UI/Company/company_profile_screen.dart';
import '../UI/Company/company_setting_screen.dart';
import '../UI/Company/show_all_jobs_screen.dart';
import '../UI/LogIn/company_login.dart';
import '../UI/LogIn/jobseeker_login.dart';
import '../UI/jobseeker/manage_account_screen.dart';
import '../UI/jobseeker/profile_screen.dart';
import '../UI/jobseeker/search_jobs_screen.dart';
import '../UI/jobseeker/show_company_profile_screen.dart';

class GlobalMethods {
  static void showErrorDialog(
      {required String error, required BuildContext ctx}) {
    showDialog(
        context: ctx,
        builder: (context) {
          return AlertDialog(
            title: const Row(
              children: [
                Padding(
                  padding: EdgeInsets.all(8.0),
                  child: Icon(
                    Icons.logout,
                    color: Colors.grey,
                    size: 35,
                  ),
                ),
                Padding(
                  padding: EdgeInsets.all(8.0),
                  child: Text("error occurred"),
                ),
              ],
            ),
            content: Text(
              error,
              style: const TextStyle(
                  color: Colors.black,
                  fontSize: 20,
                  fontStyle: FontStyle.italic),
            ),
            actions: [
              TextButton(
                  onPressed: () {
                    Navigator.canPop(context) ? Navigator.pop(context) : null;
                  },
                  child: const Text(
                    "ok",
                    style: TextStyle(color: Colors.red),
                  ))
            ],
          );
        });
  }

  static logout(context) {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black54,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Logout",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: const Text(
          "Do you want to logout?",
          style: TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                identifier.iscompany == false
                    ? {
                        Navigator.canPop(context)
                            ? Navigator.pop(context)
                            : Null,
                        Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const JobSeekerLogIn()))
                      }
                    : {
                        Navigator.canPop(context)
                            ? Navigator.pop(context)
                            : Null,
                        Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const CompanyLogIn()))
                      };
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }

  static Widget showDashBoard(context) {
    return Container(
      decoration: BoxDecoration(
          border: Border.all(width: 1, color: Colors.amber),
          borderRadius: const BorderRadius.only(
            bottomLeft: Radius.circular(15),
            bottomRight: Radius.circular(15),
          )),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          const SizedBox(
            height: 20,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: [
              Flexible(
                child: GestureDetector(
                  onTap: () {
                    identifier.iscompany == false
                        ? Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const ProfileScreen()))
                        : Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) =>
                                    const CompanyProfileScreen()));
                  },
                  child: Container(
                    decoration: const BoxDecoration(
                        color: Color.fromARGB(255, 7, 4, 53),
                        borderRadius: BorderRadius.all(Radius.circular(15))),
                    child: Column(
                      children: [
                        ClipRRect(
                            borderRadius: const BorderRadius.only(
                              topLeft: Radius.circular(15),
                              topRight: Radius.circular(15),
                            ),
                            child:
                                Image.asset("Images/profile.png", width: 175)),
                        const Padding(
                          padding: EdgeInsets.all(5.0),
                          child: Text(
                            "Profile",
                            style: TextStyle(
                              color: Colors.white,
                              fontSize: 16,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              Flexible(
                child: GestureDetector(
                  onTap: () {
                    identifier.iscompany == false
                        ? Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const SearchJobsScreen()))
                        : Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) =>
                                    const ShowAllJobsScreen()));
                  },
                  child: Container(
                    decoration: const BoxDecoration(
                        color: Color.fromARGB(255, 7, 4, 53),
                        borderRadius: BorderRadius.all(Radius.circular(15))),
                    child: Column(
                      children: [
                        ClipRRect(
                          borderRadius: const BorderRadius.only(
                            topLeft: Radius.circular(15),
                            topRight: Radius.circular(15),
                          ),
                          child: Image.asset(
                            "Images/search.jpg",
                            fit: BoxFit.cover,
                            height: 175,
                            width: 175,
                          ),
                        ),
                        const Padding(
                          padding: EdgeInsets.all(5.0),
                          child: Text(
                            "Search",
                            style: TextStyle(
                              color: Colors.white,
                              fontSize: 16,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ],
          ),
          const SizedBox(
            height: 20,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: [
              Flexible(
                child: GestureDetector(
                  onTap: () {
                    identifier.iscompany == false
                        ? Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) =>
                                    const ManageAccountScreen()))
                        : Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (context) => const CompanySetting()));
                  },
                  child: Container(
                    decoration: const BoxDecoration(
                        color: Color.fromARGB(255, 7, 4, 53),
                        borderRadius: BorderRadius.all(Radius.circular(15))),
                    child: Column(
                      children: [
                        ClipRRect(
                            borderRadius: const BorderRadius.only(
                              topLeft: Radius.circular(15),
                              topRight: Radius.circular(15),
                            ),
                            child: Image.asset("Images/manage_account.png",
                                width: 170)),
                        const Padding(
                          padding: EdgeInsets.all(5.0),
                          child: Text(
                            "Setting",
                            style: TextStyle(
                              color: Colors.white,
                              fontSize: 16,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              const SizedBox(
                width: 5,
              ),
              Flexible(
                child: GestureDetector(
                  onTap: () {
                    GlobalMethods.logout(context);
                  },
                  child: Container(
                    decoration: const BoxDecoration(
                        color: Color.fromARGB(255, 7, 4, 53),
                        borderRadius: BorderRadius.all(Radius.circular(15))),
                    child: Column(
                      children: [
                        ClipRRect(
                            borderRadius: const BorderRadius.only(
                              topLeft: Radius.circular(15),
                              topRight: Radius.circular(15),
                            ),
                            child: Image.asset(
                              "Images/logout.jpg",
                              width: 170,
                            )),
                        const Padding(
                          padding: EdgeInsets.all(5.0),
                          child: Text(
                            "Logout",
                            style: TextStyle(
                              color: Colors.white,
                              fontSize: 16,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ],
          ),
          const SizedBox(
            height: 20,
          ),
        ],
      ),
    );
  }

  static Widget textFormFields(
      {required String valuekey,
      required TextEditingController controller,
      required bool enabled,
      required Function fct,
      required int maxlength}) {
    return Padding(
      padding: const EdgeInsets.all(5),
      child: InkWell(
        onTap: () {
          fct();
        },
        child: TextFormField(
          validator: (value) {
            if (value!.isEmpty) {
              return "Value is missing";
            } else {
              return null;
            }
          },
          controller: controller,
          enabled: enabled,
          key: ValueKey(valuekey),
          style: const TextStyle(color: Colors.black),
          maxLines: 1,
          maxLength: maxlength,
          keyboardType: TextInputType.text,
          decoration: const InputDecoration(
            filled: true,
            fillColor: Colors.white54,
            enabledBorder: UnderlineInputBorder(
              borderSide: BorderSide(color: Colors.black),
            ),
            focusedBorder: UnderlineInputBorder(
              borderSide: BorderSide(color: Colors.black),
            ),
            errorBorder: UnderlineInputBorder(
              borderSide: BorderSide(color: Colors.red),
            ),
          ),
        ),
      ),
    );
  }

  static Widget textTitle({required String label}) {
    return Padding(
      padding: const EdgeInsets.all(5),
      child: Text(
        label,
        style: const TextStyle(
            color: Colors.black, fontSize: 20, fontWeight: FontWeight.bold),
      ),
    );
  }

  static Widget userInfo({required IconData myIcon, required String content}) {
    return Padding(
      padding: const EdgeInsets.only(left: 15.0, right: 15, top: 8, bottom: 8),
      child: Card(
        color: Colors.black38,
        child: Padding(
          padding: const EdgeInsets.only(top: 25.0, left: 25.0, bottom: 25.0),
          child: Row(
            children: [
              Icon(
                myIcon,
                color: Colors.white,
                size: 35,
              ),
              const SizedBox(
                width: 10,
              ),
              Text(
                content,
                style: const TextStyle(color: Colors.white54, fontSize: 20),
              )
            ],
          ),
        ),
      ),
    );
  }

  static Widget emailTextField({required TextEditingController controller}) {
    return Padding(
      padding: const EdgeInsets.all(5.0),
      child: TextFormField(
        maxLength: 50,
        style: const TextStyle(color: Colors.black),
        keyboardType: TextInputType.emailAddress,
        controller: controller,
        validator: (value) {
          if (value!.isEmpty || !value.contains("@")) {
            return "please enter a valid email address";
          } else {
            return null;
          }
        },
        decoration: const InputDecoration(
          filled: true,
          fillColor: Colors.white54,
          counterStyle: TextStyle(color: Colors.black),
          enabledBorder: UnderlineInputBorder(
            borderSide: BorderSide(color: Colors.black),
          ),
          focusedBorder: UnderlineInputBorder(
            borderSide: BorderSide(color: Colors.black),
          ),
          errorBorder: UnderlineInputBorder(
            borderSide: BorderSide(color: Colors.red),
          ),
        ),
      ),
    );
  }

  static Widget loginEmailTextField(
      {required TextEditingController controller,
      required BuildContext context,
      required FocusNode focusNode}) {
    return TextFormField(
      textInputAction: TextInputAction.next,
      onEditingComplete: () => FocusScope.of(context).requestFocus(focusNode),
      keyboardType: TextInputType.emailAddress,
      controller: controller,
      validator: (value) {
        if (value!.isEmpty || !value.contains("@")) {
          return "please enter a valid email address";
        } else {
          return null;
        }
      },
      style: const TextStyle(color: Colors.white),
      decoration: const InputDecoration(
          hintText: 'Email',
          hintStyle: TextStyle(color: Colors.white),
          enabledBorder: UnderlineInputBorder(
            borderSide: BorderSide(color: Colors.white),
          ),
          focusedBorder: UnderlineInputBorder(
            borderSide: BorderSide(color: Colors.white),
          ),
          errorBorder:
              UnderlineInputBorder(borderSide: BorderSide(color: Colors.red))),
    );
  }

  static Widget buildListViewContainer(Widget child) {
    return Container(
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(4),
          border: Border.all(color: Colors.amber)),
      height: 300,
      width: 390,
      padding: const EdgeInsets.only(top: 10, bottom: 10, right: 10, left: 0),
      child: child,
    );
  }

  static void goToCompanyProfile(context, int id) {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black87,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Move",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: const Text(
          "show company profile?",
          style: TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
                Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) =>
                            ShowCompanyProfileScreen(id: id)));
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }

  static Widget contactWithPhone(String phone) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.black54,
        child: GestureDetector(
          onTap: () async {
            {
              final Uri url = Uri.parse("tel:$phone");

              if (!await launchUrl(url)) {
                throw Exception('Could not launch $phone');
              }
            }
          },
          child: Container(
            padding: const EdgeInsets.all(10.0),
            child: Row(
              children: [
                const Icon(
                  Icons.phone,
                  color: Colors.amber,
                  size: 30,
                ),
                const SizedBox(width: 15.0),
                Text(
                  phone,
                  style: const TextStyle(
                      color: Colors.grey,
                      fontSize: 20.0,
                      fontWeight: FontWeight.w500),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }

  static Widget contactWithEmail(String email) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Card(
        color: Colors.black54,
        child: GestureDetector(
          onTap: () async {
            {
              final Uri url = Uri.parse("mailto:$email");

              if (!await launchUrl(url)) {
                throw Exception('Could not launch $email');
              }
            }
          },
          child: Container(
            padding: const EdgeInsets.all(10.0),
            child: Row(
              children: [
                const Icon(
                  Icons.email,
                  color: Colors.amber,
                  size: 30,
                ),
                const SizedBox(width: 15.0),
                Text(
                  email,
                  style: const TextStyle(
                      color: Colors.grey,
                      fontSize: 20.0,
                      fontWeight: FontWeight.w500),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }
}
