import 'package:job_portal_app/data/Common/skill.dart';

// ignore_for_file: file_names

class CV {
  int id;
  String stages;
  String certificate;
  String previousWorks;
  String languages;
  String specificationName;
  DateTime birthdate;
  String gender;
  String email;
  String address;
  String name;
  String phone;
  String image;
  List<Skill> skills;

  CV({
    required this.id,
    required this.stages,
    required this.certificate,
    required this.previousWorks,
    required this.languages,
    required this.specificationName,
    required this.birthdate,
    required this.gender,
    required this.email,
    required this.address,
    required this.name,
    required this.phone,
    required this.image,
    required this.skills,
  });

  factory CV.fromJson(Map<String, dynamic> json) {
    List<Skill> skillsList = [];
    for (var skill in json['skills']) {
      skillsList.add(Skill.fromJson(skill));
    }

    return CV(
      id: json['id'],
      stages: json['stages'],
      certificate: json['certificate'],
      previousWorks: json['previousWorks'],
      languages: json['languages'],
      specificationName: json['specificationName'],
      birthdate: DateTime.parse(json['birthdate']),
      gender: json['gender'],
      email: json['email'],
      address: json['address'],
      name: json['name'],
      phone: json['phone'],
      image: json["image"],
      skills: skillsList,
    );
  }
}
