// ignore_for_file: file_names
import 'package:job_portal_app/data/Common/skill.dart';

class Job {
  int id;
  int companyId;
  String companyName;
  String timeType;
  String name;
  String phone;
  String email;
  String description;
  int sallary;
  String specificationName;
  String status;
  String image;

  List<Skill> skills;

  Job({
    required this.companyId,
    required this.id,
    required this.companyName,
    required this.description,
    required this.name,
    required this.sallary,
    required this.specificationName,
    required this.status,
    required this.phone,
    required this.email,
    required this.timeType,
    required this.skills,
    required this.image,
  });

  factory Job.fromJson(Map<String, dynamic> json) {
    List<Skill> skillsList = [];
    for (var skill in json['skills']) {
      skillsList.add(Skill.fromJson(skill));
    }

    return Job(
        id: json['id'],
        companyId: json['companyId'],
        companyName: json['companyName'],
        description: json['description'],
        name: json['name'],
        sallary: json['sallary'],
        specificationName: json['specificationName'],
        status: json['status'],
        timeType: json['timeType'],
        skills: skillsList,
        image: json['image'],
        phone: json['phone'],
        email: json['email']);
  }
}
