import 'package:flutter/material.dart';

class NewNotificationWidget extends StatelessWidget {
  final int notificationCount;
  final VoidCallback onDismiss;
  final VoidCallback onDetails;

  const NewNotificationWidget({
    Key? key,
    required this.notificationCount,
    required this.onDismiss,
    required this.onDetails,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      width: 215,
      height: 100,
      decoration: BoxDecoration(
        color: Colors.blueGrey.shade300,
        border: Border.all(width: 1, color: Colors.black),
      ),
      child: Column(
        children: [
          Align(
            alignment: Alignment.topCenter,
            child: TextButton(
              onPressed: () {},
              child: Text(
                'New Notifications ($notificationCount)',
                style: const TextStyle(
                  color: Colors.black,
                  fontSize: 16,
                  fontWeight: FontWeight.bold,
                ),
              ),
            ),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceAround,
            children: [
              TextButton(
                onPressed: onDismiss,
                child: const Text(
                  "Ignore",
                  style: TextStyle(color: Colors.black),
                ),
              ),
              TextButton(
                onPressed: onDetails,
                child: const Text(
                  "Details",
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
