import 'package:flutter/material.dart';
import 'package:job_portal_app/UI/Notification/show_jobseekers_notification_screen.dart';
import 'package:provider/provider.dart';

import '../Services/Common/new_notification_manager.dart';
import 'new_notification_widget.dart';

// ignore: must_be_immutable
class JobseekerConsumerWidget extends StatefulWidget {
  const JobseekerConsumerWidget({
    super.key,
  });

  @override
  State<JobseekerConsumerWidget> createState() =>
      _JobseekerConsumerWidgetState();
}

class _JobseekerConsumerWidgetState extends State<JobseekerConsumerWidget> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<NewNotificationManager>(
      builder: (context, notificationManager, _) {
        if (notificationManager.hasJobseekerNewNotification) {
          return NewNotificationWidget(
            notificationCount: notificationManager.jobseekerNotificationCount,
            onDismiss: () {
              notificationManager.jobseekerDismiss();
            },
            onDetails: () {
              Navigator.push(
                context,
                MaterialPageRoute(
                  builder: (context) =>
                      const ShowJobseekersNotificationScreen(),
                ),
              );
              notificationManager.jobseekerDismiss();
            },
          );
        } else {
          return const SizedBox.shrink();
        }
      },
    );
  }
}
