import 'package:flutter/material.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/data/Company/company.dart';
import 'package:job_portal_app/logic/fetch.dart';
import 'package:url_launcher/url_launcher.dart';

// ignore: must_be_immutable
class ShowCompanyProfileScreen extends StatefulWidget {
  int id;

  ShowCompanyProfileScreen({super.key, required this.id});

  @override
  State<ShowCompanyProfileScreen> createState() =>
      _ShowCompanyProfileScreenState();
}

class _ShowCompanyProfileScreenState extends State<ShowCompanyProfileScreen> {
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Container(
        decoration: const BoxDecoration(
            gradient: LinearGradient(
                colors: [Colors.cyan, Colors.greenAccent],
                begin: Alignment.centerLeft,
                end: Alignment.centerRight,
                stops: [0.2, 0.9])),
        child: Scaffold(
          backgroundColor: Colors.transparent,
          appBar: AppBar(
            flexibleSpace: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.2, 0.9])),
            ),
            leading: IconButton(
              icon: const Icon(
                Icons.close,
                size: 20,
                color: Colors.black,
              ),
              onPressed: () {
                Navigator.pop(context);
              },
            ),
          ),
          body: FutureBuilder<Company>(
              future: fetch.fetchCompanyById(widget.id),
              builder: (context, snapshot) {
                if (snapshot.hasData) {
                  return SingleChildScrollView(
                      child: Padding(
                    padding: const EdgeInsets.all(10.0),
                    child: Container(
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15)),
                      child: Card(
                        color: Colors.black54,
                        child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Padding(
                                padding: const EdgeInsets.only(
                                    left: 8.0,
                                    right: 8.0,
                                    top: 30,
                                    bottom: 8.0),
                                child: Container(
                                  width: size.width * 0.4,
                                  height: size.width * 0.4,
                                  decoration: BoxDecoration(
                                    border: Border.all(
                                        width: 2, color: Colors.amber),
                                    shape: BoxShape.circle,
                                  ),
                                  child: ClipOval(
                                    child: Image.network(
                                      '$myUrl/${snapshot.data!.image}',
                                      fit: BoxFit.fill,
                                    ),
                                  ),
                                ),
                              ),
                              Text(
                                snapshot.data!.name,
                                style: const TextStyle(
                                    fontSize: 38.0, color: Colors.white),
                              ),
                              SizedBox(
                                width: 200,
                                height: 20,
                                child: Divider(color: Colors.cyan[100]),
                              ),
                              GestureDetector(
                                onTap: () async {
                                  {
                                    final Uri url = Uri.parse(
                                        "tel:${snapshot.data!.phone}");

                                    if (!await launchUrl(url)) {
                                      throw Exception(
                                          'Could not launch ${snapshot.data!.phone}');
                                    }
                                  }
                                },
                                child: Container(
                                  margin: const EdgeInsets.all(15.0),
                                  padding: const EdgeInsets.all(15.0),
                                  color: Colors.white54,
                                  child: Row(
                                    children: [
                                      const Icon(
                                        Icons.phone,
                                        color: Colors.amber,
                                        size: 30,
                                      ),
                                      const SizedBox(width: 15.0),
                                      Text(
                                        snapshot.data!.phone,
                                        style: const TextStyle(
                                            color: Colors.black54,
                                            fontSize: 20.0,
                                            fontWeight: FontWeight.w500),
                                      )
                                    ],
                                  ),
                                ),
                              ),
                              GestureDetector(
                                onTap: () async {
                                  {
                                    final Uri url = Uri.parse(
                                        "mailto:${snapshot.data!.email}");

                                    if (!await launchUrl(url)) {
                                      throw Exception(
                                          'Could not launch ${snapshot.data!.email}');
                                    }
                                  }
                                },
                                child: Container(
                                  margin: const EdgeInsets.all(15.0),
                                  padding: const EdgeInsets.all(15.0),
                                  color: Colors.white54,
                                  child: Row(
                                    children: [
                                      const Icon(
                                        Icons.email,
                                        color: Colors.amber,
                                        size: 30,
                                      ),
                                      const SizedBox(width: 15.0),
                                      Text(
                                        snapshot.data!.email,
                                        style: const TextStyle(
                                            color: Colors.black54,
                                            fontSize: 20.0,
                                            fontWeight: FontWeight.w500),
                                      )
                                    ],
                                  ),
                                ),
                              ),
                              Container(
                                margin: const EdgeInsets.all(15.0),
                                padding: const EdgeInsets.all(20.0),
                                color: Colors.white54,
                                child: Row(
                                  children: [
                                    const Icon(
                                      Icons.home,
                                      color: Colors.amber,
                                      size: 30,
                                    ),
                                    const SizedBox(width: 15.0),
                                    Text(
                                      snapshot.data!.address,
                                      style: const TextStyle(
                                          color: Colors.black54,
                                          fontSize: 20.0,
                                          fontWeight: FontWeight.w500),
                                    )
                                  ],
                                ),
                              ),
                              Container(
                                decoration: BoxDecoration(
                                    color: Colors.white54,
                                    borderRadius: BorderRadius.circular(10)),
                                width: MediaQuery.of(context).size.width * 0.9,
                                height: MediaQuery.of(context).size.width * 0.6,
                                margin: const EdgeInsets.all(15.0),
                                padding: const EdgeInsets.all(20.0),
                                child: Text(
                                  snapshot.data!.description,
                                  textAlign: TextAlign.justify,
                                  style: const TextStyle(
                                      color: Colors.black54,
                                      fontSize: 15.0,
                                      fontWeight: FontWeight.w500),
                                ),
                              ),
                            ]),
                      ),
                    ),
                  ));
                } else {
                  return const Center(child: CircularProgressIndicator());
                }
              }),
        ),
      ),
    );
  }

  // ignore: non_constant_identifier_names
  Widget UserInfo({required IconData myIcon, required String content}) {
    return Padding(
      padding: const EdgeInsets.all(10.0),
      child: Row(
        children: [
          Icon(myIcon, color: Colors.amber),
          const SizedBox(
            width: 10,
          ),
          Text(
            content,
            style: const TextStyle(color: Colors.white54),
          )
        ],
      ),
    );
  }
}
