import 'package:flutter/material.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../Widgets/my_jobseeker_notification_widget.dart';
import '../../data/Common/my_notification.dart';
import '../jobseeker/search_in_my_notifications_screen.dart';

class ShowJobseekersNotificationScreen extends StatefulWidget {
  const ShowJobseekersNotificationScreen({super.key});

  @override
  State<ShowJobseekersNotificationScreen> createState() =>
      _ShowJobseekersNotificationScreenState();
}

class _ShowJobseekersNotificationScreenState
    extends State<ShowJobseekersNotificationScreen> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              actions: [
                Padding(
                  padding: const EdgeInsets.only(right: 8.0),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.end,
                    children: [
                      IconButton(
                        icon: const Icon(
                          Icons.search,
                          size: 25,
                          color: Colors.black,
                        ),
                        onPressed: () {
                          Navigator.push(
                              context,
                              MaterialPageRoute(
                                  builder: (context) =>
                                      const SearchInMyNotificationsScreen()));
                        },
                      ),
                    ],
                  ),
                ),
              ],
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 20,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              title: const Text("My Notifications"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder<List<MyNotification>>(
                future: fetch.getAllNotificationByJobseekerId(),
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<MyNotification>? notifications = snapshot.data;
                    return ListView.builder(
                      itemCount: notifications!.length,
                      itemBuilder: (context, index) {
                        MyNotification notification = notifications[index];

                        return MyJobseekerNotificationWidget(
                            notification: notification);
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
