import 'dart:async';

import 'package:flutter/material.dart';
// import 'package:audioplayers/audioplayers.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import 'package:job_portal_app/UI/jobseeker/jobseeker_home_screen.dart';
import 'package:job_portal_app/logic/fetch.dart';
import 'package:provider/provider.dart';

import '../../Services/Common/new_notification_manager.dart';
import '../../Services/Common/signalR.dart';
import '../../Widgets/jobseeker_consumer_widget.dart';

// ignore: camel_case_types
class JobseekerMainScreen extends StatefulWidget {
  const JobseekerMainScreen({super.key});

  @override
  State<JobseekerMainScreen> createState() => _JobseekerMainScreenState();
}

// Future<void> playNotificationSound() async {
//   try {
//     // final player = AudioCache(prefix: 'Audios/');
//     // final url = await player.load('sound.wav');
//     // audioPlayer.setSourceUrl(url.path);//UrlSource(url as String), isLocal: true
//     await audioPlayer.play(UrlSource('$myUrl/Audios/sound.wav'));
//   } catch (error) {
//     print('Error playing notification sound: $error');
//   }
// }
// ignore: camel_case_types
class _JobseekerMainScreenState extends State<JobseekerMainScreen> {
  late NewNotificationManager jobseekernotificationManager =
      NewNotificationManager();

  // late AudioPlayer audioPlayer;
  OverlayEntry? _overlayEntry;
  signalR mysignalr = signalR();
  int y = 0;
  int x = 0;
  bool _new = false;

  @override
  void initState() {
    super.initState();
    // audioPlayer = AudioPlayer();
    _myInitState();
  }

  Future<void> _myInitState() async {
    _new = await mysignalr.asyncInitStateFromJobsseker();
    if (_new == true) {
      setState(() {
        fetchData();
        _myInitState();
      });
    }
  }

  @override
  void dispose() {
    // audioPlayer.dispose();

    mysignalr.hubConnection.stop();
    _removeOverlay();
    super.dispose();
  }

  Future<void> fetchData() async {
    try {
      y = identifier.id;
      x = await fetch.getNumberOfJobseekerNotifications(y);
      setState(() {
        jobseekernotificationManager =
            Provider.of<NewNotificationManager>(context, listen: false);
        // playNotificationSound();
        jobseekernotificationManager.updateJobseekerNotificationCount(x);
        _updateOverlay();
      });
    } catch (error) {
      // ignore: avoid_print
      print(error);
    }
  }

  void _updateOverlay() {
    if (_overlayEntry == null) {
      _overlayEntry = _createOverlayEntry();
      Overlay.of(context).insert(_overlayEntry!);
    } else {
      _overlayEntry?.markNeedsBuild();
    }
  }

  void _removeOverlay() {
    _overlayEntry?.remove();
    _overlayEntry = null;
  }

  OverlayEntry _createOverlayEntry() {
    return OverlayEntry(
      builder: (context) => const Positioned(
          bottom: 70, right: 15, child: JobseekerConsumerWidget()),
    );
  }

  @override
  Widget build(BuildContext context) {
    return const MaterialApp(
      home: Scaffold(body: JobSeekerHomeScreen()),
    );
  }
}
