import 'package:intl/intl.dart';
import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'package:job_portal_app/Services/global_methods.dart';
import 'package:job_portal_app/Services/global_variables.dart';
import '../UI/Company/show_interviews_screen.dart';
import '../UI/Interview/update_interview_screen.dart';
import '../UI/Notification/show_profile_screen.dart';
import '../UI/jobseeker/show_company_profile_screen.dart';
import '../data/Common/interview.dart';

// ignore: must_be_immutable
class InterviewWidget extends StatefulWidget {
  Interview interview;

  InterviewWidget({super.key, required this.interview});

  @override
  State<InterviewWidget> createState() => _InterviewWidgetState();
}

class _InterviewWidgetState extends State<InterviewWidget> {
  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(0),
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Card(
          color: Colors.black54,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Padding(
                padding: const EdgeInsets.all(8.0),
                child: Text(
                  (identifier.id == widget.interview.companyId)
                      ? "Interview with ${widget.interview.name} jobseeker"
                      : "Interview with ${widget.interview.name} company for ${widget.interview.jobName} work",
                  style: const TextStyle(
                      color: Colors.white54,
                      fontSize: 20,
                      fontWeight: FontWeight.bold),
                ),
              ),
              const SizedBox(
                height: 8,
              ),
              const Divider(
                thickness: 1,
                color: Colors.grey,
              ),
              SizedBox(
                width: MediaQuery.of(context).size.width,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    GestureDetector(
                      onTap: () {
                        _goToProfile(context);
                      },
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Padding(
                            padding: const EdgeInsets.all(8.0),
                            child: Container(
                              decoration: BoxDecoration(
                                border:
                                    Border.all(width: 3, color: Colors.grey),
                                image: DecorationImage(
                                  image: NetworkImage(
                                      '$myUrl/${widget.interview.image}'),
                                  fit: BoxFit.fill,
                                ),
                              ),
                              width: 100,
                              height: 120,
                            ),
                          ),
                          const SizedBox(
                            width: 10,
                          ),
                          Padding(
                            padding: const EdgeInsets.only(top: 8.0),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    const Padding(
                                      padding: EdgeInsets.all(8.0),
                                      child: Text(
                                        "Date :",
                                        style: TextStyle(
                                            color: Colors.grey,
                                            fontSize: 18,
                                            fontWeight: FontWeight.bold),
                                      ),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: Text(
                                        DateFormat.yMd().format(DateTime.parse(
                                            widget.interview.date)),
                                        textAlign: TextAlign.justify,
                                        style: const TextStyle(
                                          color: Colors.grey,
                                          fontSize: 14,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                const SizedBox(
                                  height: 5,
                                ),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    const Padding(
                                      padding: EdgeInsets.all(8.0),
                                      child: Text(
                                        "Time :",
                                        style: TextStyle(
                                            color: Colors.grey,
                                            fontSize: 18,
                                            fontWeight: FontWeight.bold),
                                      ),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: Text(
                                        DateFormat.Hm().format(DateTime.parse(
                                            widget.interview.date)),
                                        textAlign: TextAlign.justify,
                                        style: const TextStyle(
                                          color: Colors.grey,
                                          fontSize: 14,
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                const SizedBox(
                                  height: 5,
                                ),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  children: [
                                    const Padding(
                                      padding: EdgeInsets.all(8.0),
                                      child: Text(
                                        "Address :",
                                        style: TextStyle(
                                            color: Colors.grey,
                                            fontSize: 18,
                                            fontWeight: FontWeight.bold),
                                      ),
                                    ),
                                    Padding(
                                      padding: const EdgeInsets.all(8.0),
                                      child: Text(
                                        widget.interview.address,
                                        textAlign: TextAlign.justify,
                                        style: const TextStyle(
                                          color: Colors.grey,
                                          fontSize: 14,
                                        ),
                                      ),
                                    ),
                                  ],
                                )
                              ],
                            ),
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              const SizedBox(
                height: 8,
                child: Divider(
                  color: Colors.grey,
                ),
              ),
              Padding(
                padding: const EdgeInsets.all(8.0),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    MaterialButton(
                      onPressed: () {
                        _goToProfile(context);
                      },
                      color: Colors.blueAccent,
                      shape: const RoundedRectangleBorder(),
                      child: const Text(
                        "Show Profile",
                        style: TextStyle(
                          color: Colors.white,
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                    ),
                    const SizedBox(
                      width: 20,
                    ),
                    (identifier.id == widget.interview.companyId)
                        ? Row(
                            children: [
                              IconButton(
                                icon: const Icon(
                                  Icons.delete,
                                  size: 25,
                                  color: Colors.amber,
                                ),
                                onPressed: () async {
                                  _deleteInterview(widget.interview.id);
                                },
                              ),
                              IconButton(
                                icon: const Icon(
                                  Icons.edit,
                                  size: 25,
                                  color: Colors.amber,
                                ),
                                onPressed: () async {
                                  _editInterview();
                                },
                              ),
                            ],
                          )
                        : const Text(""),
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    );
  }

  void _goToProfile(context) {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black87,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Move",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: Text(
          "show ${widget.interview.name} profile?",
          style: const TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
                Navigator.push(
                    context,
                    MaterialPageRoute(
                        builder: (context) =>
                            (identifier.id == widget.interview.companyId)
                                ? ShowProfileScreen(
                                    id: widget.interview.jobSeekerId,
                                  )
                                : ShowCompanyProfileScreen(
                                    id: widget.interview.companyId,
                                  )));
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }

  void _deleteInterview(int id) {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black54,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Delete",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: Text(
          "Delete ${widget.interview.name} interview?",
          style: const TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                Navigator.pop(context);
                try {
                  _deleteSubmitForm();
                } catch (error) {
                  GlobalMethods.showErrorDialog(
                      error: error.toString(), ctx: context);
                }
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }

  void _editInterview() {
    showDialog(
      context: context,
      builder: (context) => AlertDialog(
        backgroundColor: Colors.black54,
        title: const Row(
          children: [
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Icon(
                Icons.logout,
                size: 36,
                color: Colors.white,
              ),
            ),
            Padding(
              padding: EdgeInsets.all(8.0),
              child: Text(
                "Edit",
                style: TextStyle(color: Colors.white, fontSize: 36),
              ),
            ),
          ],
        ),
        content: Text(
          "Edit ${widget.interview.name} interview?",
          style: const TextStyle(color: Colors.white, fontSize: 20),
        ),
        actions: [
          TextButton(
              onPressed: () {
                Navigator.canPop(context) ? Navigator.pop(context) : Null;
              },
              child: const Text(
                "No",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
          TextButton(
              onPressed: () {
                Navigator.pop(context);
                Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                        builder: (context) => UpdateInterviewScreen(
                              id: widget.interview.id,
                              address: widget.interview.address,
                              date: widget.interview.date,
                              jobId: widget.interview.jobId,
                            )));
              },
              child: const Text(
                "Yes",
                style: TextStyle(color: Colors.green, fontSize: 16),
              )),
        ],
      ),
    );
  }

  Future<void> _deleteSubmitForm() async {
    final url = Uri.parse('$myUrl/api/Interviews/DeleteInterview');
    final request = http.MultipartRequest('delete', url)
      ..fields['id'] = widget.interview.id.toString()
      ..fields['jobSeekerId'] = widget.interview.jobSeekerId.toString()
      ..fields['companyId'] = widget.interview.companyId.toString()
      ..fields['jobId'] = widget.interview.jobId.toString()
      ..fields['date'] = widget.interview.date
      ..fields['address'] = widget.interview.address
      ..fields['image'] = widget.interview.image
      ..fields['name'] = widget.interview.name;
    request.headers['Authorization'] = "Bearer ${identifier.token}";
    request.headers['Content-Type'] = 'application/json';

    // ignore: use_build_context_synchronously
    ScaffoldMessenger.of(context).showSnackBar(const SnackBar(
      content: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Padding(
            padding: EdgeInsets.all(5.0),
            child: Text("Deleteing..."),
          ),
          CircularProgressIndicator()
        ],
      ),
      duration: Duration(minutes: 1),
    ));

    var response = await request.send();

    if (response.statusCode == 200) {
      _popThenPush();
    } else {
      _showFail();
    }
  }

  void _popThenPush() {
    Navigator.pushReplacement(
        context,
        MaterialPageRoute(
            builder: (context) =>
                ShowInterviewsScreen(id: widget.interview.jobId)));
    ScaffoldMessenger.of(context).hideCurrentSnackBar();
    ScaffoldMessenger.of(context).showSnackBar(const SnackBar(
      content: Text('The interview deleted successfully'),
      duration: Duration(seconds: 3),
    ));
  }

  void _showFail() {
    ScaffoldMessenger.of(context).hideCurrentSnackBar();
    ScaffoldMessenger.of(context).showSnackBar(const SnackBar(
      content: Text('There was an error occurred'),
      duration: Duration(seconds: 3),
    ));
  }
}
