import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:image_picker/image_picker.dart';
import 'package:job_portal_app/Services/global_variables.dart';

import '../Services/global_methods.dart';

// ignore: must_be_immutable
class EditImageProfileWidget extends StatefulWidget {
  String imageUrl;
  final void Function(File pickedImage)? onImagePicked;

  EditImageProfileWidget({Key? key, this.onImagePicked, required this.imageUrl})
      : super(key: key);

  @override
  State<EditImageProfileWidget> createState() => _EditImageProfileWidgetState();
}

class _EditImageProfileWidgetState extends State<EditImageProfileWidget> {
  final ImagePicker _picker = ImagePicker();
  File? image;

  void takePhoto(ImageSource source) async {
    try {
      final pickedFile = await _picker.pickImage(source: source);
      if (pickedFile == null) return;
      final imageTemporery = File(pickedFile.path);
      setState(() {
        image = imageTemporery;
      });
      if (widget.onImagePicked != null) {
        widget.onImagePicked!(imageTemporery);
      }
    } on PlatformException catch (e) {
      GlobalMethods.showErrorDialog(ctx: context, error: e.toString());
    }
  }

  Widget bottomSheet() {
    return Container(
        height: 100.0,
        width: MediaQuery.of(context).size.width,
        margin: const EdgeInsets.symmetric(horizontal: 20.0, vertical: 20.0),
        child: Column(
          children: [
            const Text(
              "Choose your profile image",
              style: TextStyle(fontSize: 20.0),
            ),
            const SizedBox(height: 20.0),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceAround,
              children: <Widget>[
                TextButton(
                  child: const Row(
                    children: [Icon(Icons.camera_alt), Text(" camera")],
                  ),
                  onPressed: () {
                    takePhoto(ImageSource.camera);
                  },
                ),
                TextButton(
                  child: const Row(
                    children: [Icon(Icons.image), Text(" gallery")],
                  ),
                  onPressed: () {
                    takePhoto(ImageSource.gallery);
                  },
                ),
              ],
            )
          ],
        ));
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Stack(
        children: [
          Padding(
            padding: const EdgeInsets.all(14.0),
            child: image != null
                ? CircleAvatar(
                    radius: 80.0,
                    child: ClipOval(
                      child: Image.file(image!,
                          width: 160, height: 160, fit: BoxFit.cover),
                    ),
                  )
                : Container(
                    width: MediaQuery.of(context).size.width * 0.4,
                    height: MediaQuery.of(context).size.width * 0.4,
                    decoration: BoxDecoration(
                      border: Border.all(width: 2, color: Colors.amber),
                      shape: BoxShape.circle,
                    ),
                    child: ClipOval(
                      child: Image.network(
                        '$myUrl/${widget.imageUrl}',
                        fit: BoxFit.fill,
                      ),
                    ),
                  ),
          ),
          Positioned(
              bottom: 20.0,
              right: 20.0,
              child: InkWell(
                onTap: () {
                  showModalBottomSheet(
                    context: context,
                    builder: (builder) => bottomSheet(),
                  );
                },
                child: const Icon(
                  Icons.camera_alt,
                  color: Colors.teal,
                  size: 20.0,
                ),
              )),
        ],
      ),
    );
  }
}
