import 'package:flutter/material.dart';
import 'package:job_portal_app/Widgets/company_widget.dart';
import 'package:job_portal_app/logic/fetch.dart';

import '../../data/Company/company.dart';

// ignore: must_be_immutable
class ShowAllCompaniesScreen extends StatefulWidget {
  const ShowAllCompaniesScreen({
    super.key,
  });

  @override
  State<ShowAllCompaniesScreen> createState() => _ShowAllCompaniesScreenState();
}

class _ShowAllCompaniesScreenState extends State<ShowAllCompaniesScreen> {
  int x = 0;
  Future<List<Company>>? _futureCompanies;

  @override
  void initState() {
    _futureCompanies = fetch.getAllCompanies();
    getCompanyCount();
    super.initState();
  }

  void getCompanyCount() {
    _futureCompanies?.then((List<Company>? companyList) {
      if (companyList != null) {
        setState(() {
          x = companyList.length;
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
        child: Scaffold(
            backgroundColor: Colors.transparent,
            appBar: AppBar(
              leading: IconButton(
                icon: const Icon(
                  Icons.close,
                  size: 25,
                  color: Colors.black,
                ),
                onPressed: () {
                  Navigator.pop(context);
                },
              ),
              flexibleSpace: Container(
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        colors: [Colors.cyan, Colors.greenAccent],
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        stops: [0.2, 0.9])),
              ),
              title: Text("$x company"),
              centerTitle: true,
            ),
            body: Container(
              decoration: const BoxDecoration(
                  gradient: LinearGradient(
                      colors: [Colors.cyan, Colors.greenAccent],
                      begin: Alignment.centerLeft,
                      end: Alignment.centerRight,
                      stops: [0.1, 1])),
              child: FutureBuilder(
                future: _futureCompanies,
                builder: (context, snapshot) {
                  if (snapshot.hasData) {
                    List<Company>? companies = snapshot.data;
                    return ListView.builder(
                      itemCount: companies!.length,
                      itemBuilder: (context, index) {
                        Company company = companies[index];
                        return CompanyWidget(
                          company: company,
                        );
                      },
                    );
                  } else {
                    return const Center(child: CircularProgressIndicator());
                  }
                },
              ),
            )));
  }
}
