package Client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class Aggregator {

    private WebClient webClient;

    public Aggregator() {
        this.webClient = new WebClient();
    }

    /*send task to list of workers*/
    public List<ResponseData> sendTasksToWorkers(List<String> workersAddresses, List<String> tasks) {
        List<CompletableFuture<ResponseData>> futures = new ArrayList<>();

        for (String address : workersAddresses) {
            for (String task : tasks) {
                byte[] requestPayload = task.getBytes(StandardCharsets.UTF_8);
                CompletableFuture<ResponseData> future = webClient.sendTask(address, requestPayload);
                futures.add(future);
            }
        }

        return joinFutures(futures);
    }

    /*send task to list of workers*/
    public List<ResponseData> sendTasksToWorkers(List<String> workersAddresses, List<String> tasks, String headers) {
        List<CompletableFuture<ResponseData>> futures = new ArrayList<>();

        for (String address : workersAddresses) {
            for (String task : tasks) {
                byte[] requestPayload = task.getBytes(StandardCharsets.UTF_8);
                CompletableFuture<ResponseData> future = webClient.sendTask(address, requestPayload, headers);
                futures.add(future);
            }
        }
        return joinFutures(futures);
    }

    private List<ResponseData> joinFutures(List<CompletableFuture<ResponseData>> futures) {
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allFutures.get();
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }

        List<ResponseData> results = new ArrayList<>();
        for (CompletableFuture<ResponseData> future : futures) {
            try {
                ResponseData result = future.get();
                results.add(result);
            } catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }

        return results;
    }

}
