package Client;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    private static final String WORKER_ADDRESS_1 = "http://localhost:8080/task";
    private static final String WORKER_ADDRESS_2 = "http://localhost:8081/task";

    public static void main(String[] args) {

        Aggregator aggregator = new Aggregator();

        String task1 = "10,200";
        String task2 = "123456789,100000000000000,700000002342343";
        String headers = "X-Debug: true";

        List<ResponseData> results = aggregator.sendTasksToWorkers(Arrays.asList(WORKER_ADDRESS_1, WORKER_ADDRESS_2),
                Arrays.asList(task1, task2));
        logger.info("Results without headers \n");

        for (ResponseData result : results) {
            String serverName = result.getServerName();
            logger.info("Server Name: " + serverName);
            logger.info(result.getBody());
            String debugInfo = result.getDebuginfo();
            if(debugInfo != null && !debugInfo.isEmpty()){

                logger.info("X-Debug-Info : " + debugInfo);

            }
            logger.info("..............................................");

        }

        logger.info("Results with headers\n");

        List<ResponseData> resultsWithHeaders = aggregator.sendTasksToWorkers(Arrays.asList(WORKER_ADDRESS_1, WORKER_ADDRESS_2),
                Arrays.asList(task1, task2), headers);

        for (ResponseData result : resultsWithHeaders) {
            String serverName = result.getServerName();
            logger.info("Server Name: " + serverName);
            String debugInfo = result.getDebuginfo();
            logger.info("X-Debug-Info : " + debugInfo);
            logger.info(result.getBody());
            logger.info("..............................................");

        }
        }
    }
