package org.example.scanner;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PortScannerTest extends TestCase {
    @Test
    public void testIsPortOpen() throws ExecutionException, InterruptedException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();

        String ip = "127.0.0.1";
        int port = 25;
        int timeout = 2000;

        Future<PortStatus> future = PortScanner.isPortOpen(executorService, ip, port, timeout);
        PortStatus portStatus = future.get();

        Assert.assertEquals(port, portStatus.getPortNum());
        Assert.assertEquals(ip, portStatus.getTargetIp());
        Assert.assertTrue(portStatus.getIsOpen());

        executorService.shutdown();
    }
}